<?php
//authors Options
CSF::createSection($restlyThemeOption, array(
    'parent' => 'restly_page_options',
    'title'  => esc_html__('Author Page', 'restly'),
    'icon'   => 'fa fa-user',
    'fields' => array(
        array(
            'id'      => 'restly_authors_layout',
            'type'    => 'select',
            'title'   => esc_html__('authors Layout', 'restly'),
            'options' => array(
                'grid'          => esc_html__('Grid View', 'restly'),
                'list'          => esc_html__('List View', 'restly'),
            ),
            'default' => 'list',
            'desc'    => esc_html__('Select blog page layout.', 'restly'),
        ),
        array(
            'id'       => 'restly_authors_banner',
            'type'     => 'switcher',
            'title'    => esc_html__('Enable authors Banner', 'restly'),
            'default'  => true,
            'text_on'  => esc_html__('Yes', 'restly'),
            'text_off' => esc_html__('No', 'restly'),
            'desc'     => esc_html__('Enable or disable authors page banner.', 'restly'),
        ),
        array(
            'id'       => 'restly_authors_pagination',
            'type'     => 'switcher',
            'title'    => esc_html__('Enable authors Pagination', 'restly'),
            'default'  => true,
            'text_on'  => esc_html__('Yes', 'restly'),
            'text_off' => esc_html__('No', 'restly'),
            'desc'     => esc_html__('Enable or disable authors Pagination.', 'restly'),
        ),
        array(
            'id'     => 'restly_authors_banner_title_static_color',
            'type'   => 'color',
            'title'  => esc_html__( 'Banner Static Title Color', 'restly' ),
            'output' => '.page-header .container h2.authors-title',
            'dependency' => array('restly_authors_banner', '==', true),
            'desc'        => esc_html__('Select banner Static title color.', 'restly'),
        ),
        array(
            'id'     => 'restly_authors_banner_title_color',
            'type'   => 'color',
            'title'  => esc_html__( 'Banner Title Color', 'restly' ),
            'output' => '.authors-title span',
            'dependency' => array('restly_authors_banner', '==', true),
            'desc'        => esc_html__('Select banner title color.', 'restly'),
        ),
        array(
            'type'    => 'notice',
            'style'   => 'success',
            'content' => esc_html__( 'Author Info Section for Author Page', 'restly' ),
        ),
        array(
            'id'      => 'restly_authors_info_text',
            'type'    => 'text',
            'title'   => esc_html__('Total Post Text', 'restly'),
            'subtitle'   => esc_html__('Add Author Info Text', 'restly'),
            'default' => esc_html__('Author Info', 'restly'),
        ),
        array(
            'id'       => 'restly_authors_image',
            'type'     => 'switcher',
            'title'    => esc_html__('Enable Author Image', 'restly'),
            'default'  => true,
            'text_on'  => esc_html__('Yes', 'restly'),
            'text_off' => esc_html__('No', 'restly'),
            'desc'     => esc_html__('Enable or disable Author Image.', 'restly'),
        ),
        array(
            'id'       => 'restly_authors_name',
            'type'     => 'switcher',
            'title'    => esc_html__('Enable Author Name', 'restly'),
            'default'  => true,
            'text_on'  => esc_html__('Yes', 'restly'),
            'text_off' => esc_html__('No', 'restly'),
            'desc'     => esc_html__('Enable or disable Author Name.', 'restly'),
        ),
        array(
            'id'      => 'restly_authors_namet',
            'type'    => 'text',
            'title'   => esc_html__('Name Text', 'restly'),
            'subtitle'   => esc_html__('Add Author Name Text', 'restly'),
            'default' => esc_html__('Name:', 'restly'),
            'dependency' => array('restly_authors_name', '==', true),
        ),
        array(
            'id'       => 'restly_authors_dname',
            'type'     => 'switcher',
            'title'    => esc_html__('Enable Author Dispaly Name', 'restly'),
            'default'  => true,
            'text_on'  => esc_html__('Yes', 'restly'),
            'text_off' => esc_html__('No', 'restly'),
            'desc'     => esc_html__('Enable or disable Author Dispaly Name.', 'restly'),
        ),
        array(
            'id'      => 'restly_authors_dnamet',
            'type'    => 'text',
            'title'   => esc_html__('Dispaly Name Text', 'restly'),
            'subtitle'   => esc_html__('Add Author Dispaly Name Text', 'restly'),
            'default' => esc_html__('Display:', 'restly'),
            'dependency' => array('restly_authors_dname', '==', true),
        ),

        array(
            'id'       => 'restly_authors_email',
            'type'     => 'switcher',
            'title'    => esc_html__('Enable Author Email', 'restly'),
            'default'  => true,
            'text_on'  => esc_html__('Yes', 'restly'),
            'text_off' => esc_html__('No', 'restly'),
            'desc'     => esc_html__('Enable or disable Author Email.', 'restly'),
        ),
        array(
            'id'      => 'restly_authors_emailt',
            'type'    => 'text',
            'title'   => esc_html__('Email Name Text', 'restly'),
            'subtitle'   => esc_html__('Add Author Email Name Text', 'restly'),
            'default' => esc_html__('Email:', 'restly'),
            'dependency' => array('restly_authors_email', '==', true),
        ),
        array(
            'id'       => 'restly_authors_website',
            'type'     => 'switcher',
            'title'    => esc_html__('Enable Author Website', 'restly'),
            'default'  => true,
            'text_on'  => esc_html__('Yes', 'restly'),
            'text_off' => esc_html__('No', 'restly'),
            'desc'     => esc_html__('Enable or disable Author Website.', 'restly'),
        ),
        array(
            'id'      => 'restly_authors_websitet',
            'type'    => 'text',
            'title'   => esc_html__('Website Text', 'restly'),
            'subtitle'   => esc_html__('Add Author Website Text', 'restly'),
            'default' => esc_html__('Website:', 'restly'),
            'dependency' => array('restly_authors_website', '==', true),
        ),
        array(
            'id'       => 'restly_authors_total_post',
            'type'     => 'switcher',
            'title'    => esc_html__('Enable Author Total Post', 'restly'),
            'default'  => true,
            'text_on'  => esc_html__('Yes', 'restly'),
            'text_off' => esc_html__('No', 'restly'),
            'desc'     => esc_html__('Enable or disable Author Total Post.', 'restly'),
        ),
        array(
            'id'      => 'restly_authors_total_postt',
            'type'    => 'text',
            'title'   => esc_html__('Total Post Text', 'restly'),
            'subtitle'   => esc_html__('Add Author Total Post Text', 'restly'),
            'default' => esc_html__('Total Post:', 'restly'),
            'dependency' => array('restly_authors_total_post', '==', true),
        ),
        array(
            'id'       => 'restly_authors_dec',
            'type'     => 'switcher',
            'title'    => esc_html__('Enable Author Description', 'restly'),
            'default'  => true,
            'text_on'  => esc_html__('Yes', 'restly'),
            'text_off' => esc_html__('No', 'restly'),
            'desc'     => esc_html__('Enable or disable Author Description.', 'restly'),
        ),
        array(
            'id'       => 'restly_authors_social',
            'type'     => 'switcher',
            'title'    => esc_html__('Enable Author Social', 'restly'),
            'default'  => true,
            'text_on'  => esc_html__('Yes', 'restly'),
            'text_off' => esc_html__('No', 'restly'),
            'desc'     => esc_html__('Enable or disable Author Social.', 'restly'),
        ),
    )
));