<?php
//Blog Page Options
CSF::createSection($restlyThemeOption, array(
    'parent' => 'restly_page_options',
    'title'  => esc_html__('Blog Page', 'restly'),
    'icon'   => 'fa fa-pencil-square-o',
    'fields' => array(
        array(
            'id'      => 'restly_blog_layout',
            'type'    => 'select',
            'title'   => esc_html__('Blog Layout', 'restly'),
            'options' => array(
                'grid'          => esc_html__('Grid Full', 'restly'),
                'grid-ls'       => esc_html__('Grid With Left Sidebar', 'restly'),
                'grid-rs'       => esc_html__('Grid With Right Sidebar', 'restly'),
                'left-sidebar'  => esc_html__('Left Sidebar', 'restly'),
                'right-sidebar' => esc_html__('Right Sidebar', 'restly'),
            ),
            'default' => 'right-sidebar',
            'desc'    => esc_html__('Select blog page layout.', 'restly'),
        ),
        array(
            'id'       => 'restly_blog_banner_enable',
            'type'     => 'switcher',
            'title'    => esc_html__('Enable Banner', 'restly'),
            'default'  => true,
            'text_on'  => esc_html__('Yes', 'restly'),
            'text_off' => esc_html__('No', 'restly'),
            'desc'     => esc_html__('Hide / Show Banner.', 'restly'),
        ),
        array(
            'id'         => 'restly_blog_title',
            'type'       => 'text',
            'title'      => esc_html__('Banner Title', 'restly'),
            'dependency' => array( 'restly_blog_banner_enable', '==', 'true' ),
            'desc'       => esc_html__('Type blog banner title here.', 'restly'),
        ),
        array(
            'id'         => 'restly_blog_home_title',
            'type'       => 'text',
            'default'   => esc_html__('Restly', 'restly'),
            'title'      => esc_html__('Banner Home Text', 'restly'),
            'dependency' => array( 'restly_blog_banner_enable', '==', 'true' ),
            'desc'       => esc_html__('Type blog banner Home Text here.', 'restly'),
        ),
        array(
            'id'         => 'restly_blog_home_stitle',
            'type'       => 'text',
            'title'      => esc_html__('Banner Home Sub Text', 'restly'),
            'dependency' => array( 'restly_blog_banner_enable', '==', 'true' ),
            'default'   => esc_html__('Blog Standard', 'restly'),
            'desc'       => esc_html__('Type blog banner Home Sub Text here.', 'restly'),
        ),
        array(
            'id'       => 'restly_post_author',
            'type'     => 'switcher',
            'title'    => esc_html__('Show Author Name', 'restly'),
            'default'  => true,
            'text_on'  => esc_html__('Yes', 'restly'),
            'text_off' => esc_html__('No', 'restly'),
            'desc'     => esc_html__('Hide / Show post author name.', 'restly'),
        ),

        array(
            'id'       => 'restly_post_date',
            'type'     => 'switcher',
            'title'    => esc_html__('Show Post Date', 'restly'),
            'default'  => true,
            'text_on'  => esc_html__('Yes', 'restly'),
            'text_off' => esc_html__('No', 'restly'),
            'desc'     => esc_html__('Hide / Show post date.', 'restly'),
        ),

        array(
            'id'         => 'restly_cmnt_number',
            'type'       => 'switcher',
            'title'      => esc_html__('Show Comment Number', 'restly'),
            'default'    => true,
            'text_on'    => esc_html__('Yes', 'restly'),
            'text_off'   => esc_html__('No', 'restly'),
            'desc'       => esc_html__('Hide / Show post comment number.', 'restly'),
        ),

        array(
            'id'         => 'restly_show_category',
            'type'       => 'switcher',
            'title'      => esc_html__('Show Category Name', 'restly'),
            'default'    => true,
            'text_on'    => esc_html__('Yes', 'restly'),
            'text_off'   => esc_html__('No', 'restly'),
            'desc'       => esc_html__('Hide / Show post category name.', 'restly'),
        ),
        array(
            'id'         => 'restly_share_blog',
            'type'       => 'switcher',
            'title'      => esc_html__('Show Share Icon', 'restly'),
            'default'    => false,
            'text_on'    => esc_html__('Yes', 'restly'),
            'text_off'   => esc_html__('No', 'restly'),
            'desc'       => esc_html__('Hide / Show post category name.', 'restly'),
        ),
        array(
            'id'         => 'restly_show_pagination',
            'type'       => 'switcher',
            'title'      => esc_html__('Show Pagination', 'restly'),
            'default'    => true,
            'text_on'    => esc_html__('Yes', 'restly'),
            'text_off'   => esc_html__('No', 'restly'),
            'desc'       => esc_html__('Hide / Show post category name.', 'restly'),
        ),
        array(
            'id'         => 'restly_show_readmore',
            'type'       => 'switcher',
            'title'      => esc_html__('Show Readmore Button', 'restly'),
            'default'    => true,
            'text_on'    => esc_html__('Yes', 'restly'),
            'text_off'   => esc_html__('No', 'restly'),
            'desc'       => esc_html__('Hide / Show post category name.', 'restly'),
        ),
        array(
            'id'         => 'restly_blog_read_text',
            'type'       => 'text',
            'default'   => esc_html__('Read More', 'restly'),
            'title'      => esc_html__('Read More Text', 'restly'),
            'dependency' => array( 'restly_show_readmore', '==', 'true' ),
            'desc'       => esc_html__('Add ReadMore Text here.', 'restly'),
        ),
    )
));