<?php
if ( !defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

// Header Setings
CSF::createSection( $restlyThemeOption, array(
    'id'    => 'restly_header_settings',
    'title' => esc_html__( 'Header Settings', 'restly' ),
    'icon'  => 'fa fa-header',
) );

// Header Style
CSF::createSection( $restlyThemeOption, array(
    'parent' => 'restly_header_settings',
    'title'  => esc_html__( 'Header Style', 'restly' ),
    'icon'   => 'fas fa-arrow-right',
    'fields' => array(
        array(
            'id'       => 'restly_header_styles',
            'type'     => 'image_select',
            'title'    => esc_html__( 'Select Style', 'restly' ),
            'options'  => array(
                'one'   => get_theme_file_uri( 'assets/image/header-1.jpg' ),
                'two'   => get_theme_file_uri( 'assets/image/header-2.jpg' ),
                'three' => get_theme_file_uri( 'assets/image/header-3.jpg' ),
                'four' => get_theme_file_uri( 'assets/image/header-4.jpg' ),
                'five' => get_theme_file_uri( 'assets/image/header-5.jpg' ),
                'six' => get_theme_file_uri( 'assets/image/header-6.jpg' ),
                'seven' => get_theme_file_uri( 'assets/image/header-7.jpg' ),
                'eight' => get_theme_file_uri( 'assets/image/header-8.jpg' ),
                'nine' => get_theme_file_uri( 'assets/image/header-9.jpg' ),
                'ten' => get_theme_file_uri( 'assets/image/header-10.jpg' ),
            ),
            'default'  => 'three',
            'subtitle' => esc_html__( 'Choose Your Header Style For Global', 'restly' ),
        ),
        array(
            'id'         => 'restly_enable_sticky_menu',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Sticky Menu', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Sticky Menu If you need', 'restly' ),
            'default'    => true,
        ),
        array(
            'id'         => 'restly_header_sticky',
            'type'       => 'color',
            'title'      => esc_html__( 'Sticky Menu Background', 'restly' ),
            'subtitle'   => esc_html__( 'Add Background Color for Sticky Menu', 'restly' ),
            'output_mode' => 'background-color',
            'output'     => '.main-header.sticky-bar',
            'output_important' => true,
            'dependency' => array( 'restly_enable_sticky_menu|restly_header_styles', '==|not-any', 'true|ten'),
        ),
        array(
            'id'         => 'restly_header_sticky10',
            'type'       => 'color',
            'title'      => esc_html__( 'Sticky Menu Background', 'restly' ),
            'subtitle'   => esc_html__( 'Add Background Color for Sticky Menu', 'restly' ),
            'output_mode' => 'background-color',
            'output'     => '.header-ten .sticky-bar .header-upper',
            'output_important' => true,
            'dependency' => array( 'restly_enable_sticky_menu|restly_header_styles', '==|any', 'true|ten'),
        ),
        array(
            'type'    => 'subheading',
            'content' => esc_html__( 'Mobile Menu Design', 'restly' ),
        ),
        array(
            'id'         => 'restly_header_mobile_menus',
            'type'       => 'button_set',
            'title'      => esc_html__( 'Select Style', 'restly' ),
            'subtitle'      => esc_html__( 'Select Your Header Mobile Menu Style.', 'restly' ),
            'options'    => array(
              '1' => esc_html__( 'Classic Style', 'restly' ),
              '2' => esc_html__( 'Off Canvas Style', 'restly' ),
            ),
            'default'    => '2'
        ),
    ),
) );
// End Header Style

// Header Options
CSF::createSection( $restlyThemeOption, array(
    'parent' => 'restly_header_settings',
    'title'  => esc_html__( 'Top Header Options', 'restly' ),
    'icon'   => 'fas fa-arrow-right',
    'fields' => array(
        // A Subheading
        array(
            'type'    => 'subheading',
            'content' => esc_html__( 'Top Header Left', 'restly' ),
            'dependency' => array( 'restly_header_styles', 'not-any', 'six,seven,eight,nine,ten', 'all' ),
        ),
        array(
            'id'       => 'restly_top_left_header_group',
            'type'     => 'group',
            'title'    => esc_html__( 'Top Header Left Content', 'restly' ),
            'subtitle' => esc_html__( 'Add your Content forTop Header Left', 'restly' ),
            'dependency' => array( 'restly_header_styles', 'not-any', 'six,,seven,eight,nine,ten', 'all' ),
            'fields'   => array(
                array(
                    'id'    => 'restly_left_topH_label',
                    'type'  => 'text',
                    'title' => esc_html__( 'Label', 'restly' ),
                ),
                array(
                    'id'            => 'restly_left_topH_dec',
                    'type'          => 'wp_editor',
                    'media_buttons' => false,
                    'height'        => '100px',
                    'title'         => esc_html__( 'Content', 'restly' ),
                    'desc'          => esc_html__( 'Please Add your content for Top Header Left Section', 'restly' ),
                ),
            ),
            'default'  => array(
                array(
                    'restly_left_topH_label' => esc_html__( 'Call Us:', 'restly' ),
                    'restly_left_topH_dec'   => esc_html__( '548978478', 'restly' ),
                ),
                array(
                    'restly_left_topH_label' => esc_html__( 'Email us:', 'restly' ),
                    'restly_left_topH_dec'   => esc_html__( 'demo@example.com', 'restly' ),
                ),
                array(
                    'restly_left_topH_label' => esc_html__( 'Our address:', 'restly' ),
                    'restly_left_topH_dec'   => esc_html__( '45 Dream street Austria', 'restly' ),
                ),
            ),
        ),

        array(
            'type'    => 'subheading',
            'content' => esc_html__( 'Header Top Right Section', 'restly' ),
            'dependency' => array( 'restly_header_styles', 'not-any', 'six,seven,eight,nine,ten', 'all' ),
        ),
        array(
            'id'      => 'restly_top_hopen_time',
            'type'    => 'fieldset',
            'title'   => esc_html__( 'Open Time', 'restly' ),
            'dependency' => array( 'restly_header_styles', 'not-any', 'six,seven,eight,nine,ten', 'all' ),
            'fields'  => array(
                array(
                    'id'    => 'restly_top_hopen_icon',
                    'type'  => 'icon',
                    'title' => esc_html__( 'Icon', 'restly' ),
                ),
                array(
                    'id'    => 'restly_top_hopen_text',
                    'type'  => 'text',
                    'title' => esc_html__( 'Text', 'restly' ),
                ),
            ),
            'default' => array(
                'restly_top_hopen_icon' => 'fas fa-clock',
                'restly_top_hopen_text' => esc_html__( '08:00 am - 06:00 pm', 'restly' ),
            ),
        ),
        // for Header Eight 
        array(
            'id'      => 'restly_top_hotlines',
            'type'    => 'fieldset',
            'title'   => esc_html__( 'Hotline Options', 'restly' ),
            'subtitle'   => esc_html__( 'Add Hotline Content Here', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'eight', 'all' ),
            'fields'  => array(
                array(
                    'id'    => 'restly_top_hotline_icon',
                    'type'  => 'icon',
                    'title' => esc_html__( 'Hotline Icon', 'restly' ),
                ),
                array(
                    'id'    => 'restly_top_hotline_text',
                    'type'  => 'text',
                    'title' => esc_html__( 'Label Text', 'restly' ),
                ),
                array(
                    'id'            => 'restly_top_hotline_number',
                    'type'          => 'wp_editor',
                    'title' =>      esc_html__( 'Phone Number', 'restly' ),
                    'tinymce'       => true,
                    'quicktags'     => true,
                    'media_buttons' => false,
                    'height'        => '100px',
                ),
            ),
            'default' => array(
                'restly_top_hotline_icon' => 'fas fa-headset',
                'restly_top_hotline_text' => esc_html__( 'Hotline', 'restly' ),
                'restly_top_hotline_number' => esc_html__( '+123 456 789', 'restly' ),
            ),
        ),
        array(
            'id'      => 'restly_top_eight_email',
            'type'    => 'fieldset',
            'title'   => esc_html__( 'Email Options Options', 'restly' ),
            'subtitle'   => esc_html__( 'Add Email Content Here', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'eight', 'all' ),
            'fields'  => array(
                array(
                    'id'    => 'restly_top_eight_email_icon',
                    'type'  => 'icon',
                    'title' => esc_html__( 'Email Icon', 'restly' ),
                    'subtitle' => esc_html__( 'Add icon for Email text', 'restly' ),
                ),
                array(
                    'id'            => 'restly_top_eemailt_address',
                    'type'          => 'wp_editor',
                    'title' =>      esc_html__( 'Email Address', 'restly' ),
                    'tinymce'       => true,
                    'quicktags'     => true,
                    'media_buttons' => false,
                    'height'        => '100px',
                ),
            ),
            'default' => array(
                'restly_top_eight_email_icon' => 'far fa-envelope',
                'restly_top_eemail_text' => esc_html__( 'Email Address', 'restly' ),
                'restly_top_eemailt_address' => esc_html__( 'info.Restly@gmail.com', 'restly' ),
            ),
        ),


        array(
            'id'      => 'restly_header_top_right_socials',
            'type'    => 'group',
            'title'   => esc_html__( 'Select Social', 'restly' ),
            'dependency' => array( 'restly_header_styles', 'not-any', 'six,seven,nine,ten', 'all' ),
            'fields'  => array(
                array(
                    'id'    => 'restly_top_hsocial_label',
                    'type'  => 'text',
                    'title' => esc_html__( 'Label', 'restly' ),
                ),
                array(
                    'id'    => 'restly_top_hsocial_icon',
                    'type'  => 'icon',
                    'title' => esc_html__( 'Icon', 'restly' ),
                ),
                array(
                    'id'    => 'restly_top_hsocial_link',
                    'type'  => 'text',
                    'title' => esc_html__( 'Link', 'restly' ),
                ),
                array(
                    'id'      => 'restly_top_hsocial_newtab',
                    'type'    => 'checkbox',
                    'title'   => esc_html__( 'Open New Tab', 'restly' ),
                    'label'   => esc_html__( 'Do You need New Tab for open ?', 'restly' ),
                    'default' => false // or false
                ),
            ),
            'default' => array(
                array(
                    'restly_top_hsocial_label' => esc_html__( 'Facebook', 'restly' ),
                    'restly_top_hsocial_icon'  => 'fab fa-facebook-f',
                    'restly_top_hsocial_link'  => esc_html__( '#', 'restly' ),
                    'restly_top_hsocial_newtab' => false
                ),
                array(
                    'restly_top_hsocial_label' => esc_html__( 'Twitter', 'restly' ),
                    'restly_top_hsocial_icon'  => 'fab fa-twitter',
                    'restly_top_hsocial_link'  => esc_html__( '#', 'restly' ),
                    'restly_top_hsocial_newtab' => false
                ),
                array(
                    'restly_top_hsocial_label' => esc_html__( 'Instagram', 'restly' ),
                    'restly_top_hsocial_icon'  => 'fab fa-instagram',
                    'restly_top_hsocial_link'  => esc_html__( '#', 'restly' ),
                    'restly_top_hsocial_newtab' => false
                ),
                array(
                    'restly_top_hsocial_label' => esc_html__( 'Pinterest', 'restly' ),
                    'restly_top_hsocial_icon'  => 'fab fa-pinterest-p',
                    'restly_top_hsocial_link'  => esc_html__( '#', 'restly' ),
                    'restly_top_hsocial_newtab' => false
                ),
            ),
        ),
        array(
            'type'    => 'notice',
            'style'   => 'warning',
            'content' => esc_html__( 'No Top Section for Selected header', 'restly' ),
            'dependency' => array( 'restly_header_styles', 'any', 'six,seven,nine', 'all' ),
        ),
        
        //////// TOP HEADER FOR TEN /////////////
        array(
            'type'    => 'heading',
            'content' => esc_html__( 'Add Header Top Content', 'restly' ),
            'dependency' => array( 'restly_header_styles', 'any', 'ten', 'all' ),
        ),
        array(
            'id'         => 'restly_show_top_header10',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Top Header', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Top Header Option', 'restly' ),
            'default'    => true,
            'dependency' => array( 'restly_header_styles', '==', 'ten', 'all' ),
        ),
        array(
            'id'            => 'restly_header_top_10',
            'type'          => 'wp_editor',
            'title'         => esc_html__( 'Content', 'restly' ),
            'subtitle'         => esc_html__( 'Add Content for header style ten top section', 'restly' ),
            'tinymce'       => true,
            'quicktags'     => true,
            'media_buttons' => false,
            'height'        => '100px',
            'default'       => __('<p>Welcome to Saaxio a modern saas landing template. Have any projects <a href="#">Contact Us</a></p>','restly'),
            'dependency'    => array( 'restly_header_styles|restly_show_top_header10', 'any|==', 'ten|true', 'all' ),
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'success',
            'content'    => esc_html__( 'Style Options', 'restly' ),
            'dependency' => array( 'restly_header_styles|restly_show_top_header10', '==|==', 'ten|true', 'all' ),
        ),
        array(
            'id'         => 'restly_top_header10_bg',
            'type'       => 'background',
            'title'      => esc_html__( 'Background', 'restly' ),
            'subtitle'   => esc_html__( 'Add Background Color or Image', 'restly' ),
            'dependency' => array( 'restly_header_styles|restly_show_top_header10', '==|', 'ten|true', 'all' ),
            'default'    => array(
                'background-color' => '#104cba',
            ),
            'output'     => '.header-ten .header-top',
        ),
        
        array(
            'id'         => 'restly_top_header10_text_c',
            'type'       => 'color',
            'title'      => esc_html__( 'Text Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Header top Content', 'restly' ),
            'dependency' => array( 'restly_header_styles|restly_show_top_header10', '==|', 'ten|true', 'all' ),
            'output'     => '.header-ten .header-top',
        ),
        array(
            'id'         => 'restly_top_header10_link_c',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Link Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Header top Links Normal and Hover', 'restly' ),
            'output'     => '.header-ten .header-top a',
            'dependency' => array( 'restly_header_styles|restly_show_top_header10', '==|==', 'ten|true', 'all' ),
        ),
        
    ),
) );


CSF::createSection( $restlyThemeOption, array(
    'parent' => 'restly_header_settings',
    'title'  => esc_html__( 'Header Main Options', 'restly' ),
    'icon'   => 'fas fa-arrow-right',
    'fields' => array(
        array(
            'id'         => 'restly_show_hlogo1',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Logo', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Logo Options if you need', 'restly' ),
            'default'    => true,
            'dependency' => array( 'restly_header_styles', '==', 'one', 'all' ),
        ),
        array(
            'id'         => 'restly_logo1',
            'type'       => 'media',
            'title'      => esc_html__( 'SIte Logo', 'restly' ),
            'subtitle'   => esc_html__( 'Upload Header Logo if you do not use Wordpress Default logo option ', 'restly' ),
            'library'    => 'image',
            'dependency' => array( 'restly_header_styles|restly_show_hlogo1', '==|==', 'one|true', 'all' ),
        ),
        array(
            'id'          => 'restly_logo1_size',
            'type'        => 'number',
            'title'       => esc_html__( 'Logo Size', 'restly' ),
            'subtitle'       => esc_html__( 'Add logo Size if you need Logo Size', 'restly' ),
            'unit'        => 'px',
            'output'      => '.header-one .site-branding img',
            'output_mode' => 'width',
            'dependency'  => array( 'restly_header_styles', '==', 'one', 'all' ),
        ),
        array(
            'id'         => 'restly_logo1_bg',
            'type'       => 'color',
            'title'      => esc_html__( 'Logo Background', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Logo Background', 'restly' ),
            'default'    => '#104cba',
            'dependency' => array( 'restly_header_styles|restly_show_hlogo1', '==|==', 'one|true', 'all' ),
            'output'     => '.logo-area.logobg:after',
            'output_mode' => 'background-color'
        ),
        
        
        
        
        array(
            'type'       => 'submessage',
            'style'      => 'success',
            'content'    => esc_html__( 'Top Header Options', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'one', 'all' ),
        ),
        array(
            'id'         => 'restly_show_top_header',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Top Header', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Top Header Option', 'restly' ),
            'default'    => true,
            'dependency' => array( 'restly_header_styles', '==', 'one', 'all' ),
        ),
        array(
            'id'         => 'restly_top_header1_bg',
            'type'       => 'background',
            'title'      => esc_html__( 'Background', 'restly' ),
            'subtitle'   => esc_html__( 'Add Background Color or Image', 'restly' ),
            'dependency' => array( 'restly_header_styles|restly_show_top_header', '==|==', 'one|true', 'all' ),
            'default'    => array(
                'background-color' => '#e5eef6',
            ),
            'output'     => '.header-top',
        ),
        array(
            'id'         => 'restly_top_header1_label_c',
            'type'       => 'color',
            'title'      => esc_html__( 'Label Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Header top Label', 'restly' ),
            'default'    => '#1d2c38',
            'dependency' => array( 'restly_header_styles|restly_show_top_header', '==|==', 'one|true', 'all' ),
            'output'     => '.header-top ul li span',
        ),
        array(
            'id'         => 'restly_top_header1_text_c',
            'type'       => 'color',
            'title'      => esc_html__( 'Text Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Header top Content', 'restly' ),
            'default'    => '#1d2c38',
            'output'     => '.header-top ul li',
            'dependency' => array( 'restly_header_styles|restly_show_top_header', '==|==', 'one|true', 'all' ),
        ),
        array(
            'id'         => 'restly_top_header1_icon_c',
            'type'       => 'color',
            'title'      => esc_html__( 'Icon Color', 'restly' ),
            'subtitle'   => esc_html__( 'Withour Link Icon Color', 'restly' ),
            'default'    => '#104cba',
            'output'     => '.office-time i',
            'dependency' => array( 'restly_header_styles|restly_show_top_header', '==|==', 'one|true', 'all' ),
        ),
        array(
            'id'         => 'restly_top_header1_link_c',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Link Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Header top Links Normal and Hover', 'restly' ),
            'output'     => '.header-top ul li a',
            'default'    => array(
                'color' => '#1d2c38',
                'hover' => '#104cba',
            ),
            'dependency' => array( 'restly_header_styles|restly_show_top_header', '==|==', 'one|true', 'all' ),
        ),
        
        
        
    
        
        
        array(
            'type'       => 'submessage',
            'style'      => 'success',
            'content'    => esc_html__( 'Menu Section Options', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'one', 'all' ),
        ),
        array(
            'id'         => 'restly_top_header1_menu_ncolors',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Menu Color', 'restly' ),
            'subtitle'   => esc_html__( 'Nav Menu Normal and Hover Color', 'restly' ),
            'output'     => '.main-navigation ul li a',
            'dependency' => array( 'restly_header_styles', '==', 'one', 'all' ),
            'default'    => array(
                'color' => '#1d2c38',
                'hover' => '#104cba',
            ),
        ),
        array(
            'id'         => 'restly_header1_menu_bg',
            'type'       => 'background',
            'title'      => esc_html__( 'Background', 'restly' ),
            'subtitle'   => esc_html__( 'Add Background Color for Menu Area', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'one', 'all' ),
            'default'    => array(
                'background-color' => '#ffffff',
            ),
            'output'     => '.header-one .main-header.header-fluid .navbar',
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'Sub menu Options', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'one', 'all' ),
        ),
        array(
            'id'         => 'restly_header1_menu_bg',
            'type'       => 'color_group',
            'title'      => esc_html__( 'Sub menu Colors', 'restly' ),
            'subtitle'   => esc_html__( 'Add SubMenu Color', 'restly' ),
            'options'    => array(
                'restly_hea1_submeni_bgc'     => esc_html__( 'Box Background', 'restly' ),
                'restly_hea1_submeni_textc'   => esc_html__( 'Text Color', 'restly' ),
                'restly_hea1_submeni_texthc'  => esc_html__( 'Text Hover/active Color', 'restly' ),
                'restly_hea1_submeni_texthbg' => esc_html__( 'Hover/active BG Color', 'restly' ),
            ),
            'default'    => array(
                'restly_hea1_submeni_bgc'     => '#ffffff',
                'restly_hea1_submeni_textc'   => '#1d2c38',
                'restly_hea1_submeni_texthc'  => '#ffffff',
                'restly_hea1_submeni_texthbg' => '#104cba',
            ),
            'dependency' => array( 'restly_header_styles', '==', 'one', 'all' ),
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'Header Menu Attribute Options', 'restly' ),
        ),
        array(
            'id'         => 'restly_header_menu_attribute_c',
            'type'       => 'color',
            'title'      => esc_html__( 'Text Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color For Menu Attribute Text', 'restly' ),
            'output_mode' => 'color',
            'output'     => '.navbar ul li a[title]:after',
            'output_important' => true
        ),
        array(
            'id'         => 'restly_header_menu_attribute_bg',
            'type'       => 'color',
            'title'      => esc_html__( 'Background Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Background Color For Menu Attribute', 'restly' ),
            'output_mode' => 'background-color',
            'output'     => '.navbar ul li a[title]:after',
            'output_important' => true
        ),
        array(
            'id'         => 'restly_header_menu_attribute_border',
            'type'       => 'color',
            'title'      => esc_html__( 'Symble Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Symble Color For Menu Attribute', 'restly' ),
            'output_mode' => 'border-left-color',
            'output'     => '.navbar ul li a[title]:before',
            'output_important' => true
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'CTA Button Option', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'one', 'all' ),
        ),
        array(
            'id'         => 'restly_show_cta',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable CTA Button', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Header CTA button if you need', 'restly' ),
            'default'    => true,
            'dependency' => array( 'restly_header_styles', '==', 'one', 'all' ),
        ),
        array(
            'id'          => 'restly_cta_bg',
            'type'        => 'color',
            'title'       => esc_html__( 'CTA Button Bg', 'restly' ),
            'subtitle'    => esc_html__( 'Add CTA Button Background Color', 'restly' ),
            'default'     => '#104cba',
            'output'      => '.header-one .button .theme-btns',
            'output_mode' => 'background-color',
            'dependency'  => array( 'restly_header_styles|restly_show_cta', '==|==', 'one|true', 'all' ),
        ),
        array(
            'id'          => 'restly_cta_bgh',
            'type'        => 'color',
            'title'       => esc_html__( 'CTA Button Hover Bg', 'restly' ),
            'subtitle'    => esc_html__( 'Add CTA Button Hover Background Color', 'restly' ),
            'default'     => '#1d2c38',
            'output'      => '.header-one .button .theme-btns:hover',
            'output_mode' => 'background-color',
            'dependency'  => array( 'restly_header_styles|restly_show_cta', '==|==', 'one|true', 'all' ),
        ),
        array(
            'id'         => 'restly_cta_text_color',
            'type'       => 'link_color',
            'title'      => esc_html__( 'CTA Button Text Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add CTA Button Text Hover and Normal Color', 'restly' ),
            'output'     => '.header-one .button .theme-btns',
            'dependency' => array( 'restly_header_styles|restly_show_cta', '==|==', 'one|true', 'all' ),
            'default'    => array(
                'color' => '#ffffff',
                'hover' => '#ffffff',
            ),
        ),

        ////////////////////
        // Header Two Options //
        /////////////////////

        array(
            'id'         => 'restly_show_hlogo2',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Logo', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Logo Options if you need', 'restly' ),
            'default'    => true,
            'dependency' => array( 'restly_header_styles', '==', 'two', 'all' ),
        ),
        array(
            'id'         => 'restly_logo2',
            'type'       => 'media',
            'title'      => esc_html__( 'SIte Logo', 'restly' ),
            'subtitle'   => esc_html__( 'Upload Header Logo if you do not use Wordpress Default logo option ', 'restly' ),
            'library'    => 'image',
            'dependency' => array( 'restly_header_styles|restly_show_hlogo2', '==|==', 'two|true', 'all' ),
        ),
        array(
            'id'          => 'restly_logo2_size',
            'type'        => 'number',
            'title'       => esc_html__( 'Logo Size', 'restly' ),
            'subtitle'       => esc_html__( 'Add logo Size if you need Logo Size', 'restly' ),
            'unit'        => 'px',
            'output'      => '.header-two .site-branding img',
            'output_mode' => 'width',
            'dependency'  => array( 'restly_header_styles', '==', 'two', 'all' ),
        ),
        array(
            'id'          => 'restly_header2_border_color',
            'type'        => 'color',
            'title'       => esc_html__( 'Border Color', 'restly' ),
            'subtitle'    => esc_html__( 'Add Header Border Color', 'restly' ),
            'default'     => '#4e597b',
            'dependency'  => array( 'restly_header_styles', '==', 'two', 'all' ),
            'output_mode' => 'border-color',
            'output'      => '.header-two .main-header.header-fluid,.header-two .main-header-right,.header-two .header-top',
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'success',
            'content'    => esc_html__( 'Top Header Options', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'two', 'all' ),
        ),
        array(
            'id'         => 'restly_show_top_header2',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Top Header', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Top Header Option', 'restly' ),
            'default'    => true,
            'dependency' => array( 'restly_header_styles', '==', 'two', 'all' ),
        ),
        array(
            'id'         => 'restly_top_header2_bg',
            'type'       => 'background',
            'title'      => esc_html__( 'Background', 'restly' ),
            'subtitle'   => esc_html__( 'Add Background Color or Image', 'restly' ),
            'dependency' => array( 'restly_header_styles|restly_show_top_header2', '==|==', 'two|true', 'all' ),
            'output'     => '.header-two .header-top',
        ),
        array(
            'id'         => 'restly_top_header2_label_c',
            'type'       => 'color',
            'title'      => esc_html__( 'Label Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Header top Label', 'restly' ),
            'default'    => '#ffffff',
            'dependency' => array( 'restly_header_styles|restly_show_top_header2', '==|==', 'two|true', 'all' ),
            'output'     => '.header-two .header-top ul li span',
        ),
        array(
            'id'         => 'restly_top_header2_text_c',
            'type'       => 'color',
            'title'      => esc_html__( 'Text Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Header top Content', 'restly' ),
            'default'    => '#ffffff',
            'output'     => '.header-two .header-top ul li',
            'dependency' => array( 'restly_header_styles|restly_show_top_header2', '==|==', 'two|true', 'all' ),
        ),
        array(
            'id'         => 'restly_top_header2_icon_c',
            'type'       => 'color',
            'title'      => esc_html__( 'Icon Color', 'restly' ),
            'subtitle'   => esc_html__( 'Withour Link Icon Color', 'restly' ),
            'default'    => '#ffffff',
            'output'     => '.header-two .office-time i',
            'dependency' => array( 'restly_header_styles|restly_show_top_header2', '==|==', 'two|true', 'all' ),
        ),
        array(
            'id'         => 'restly_top_header2_link_c',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Link Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Header top Links Normal and Hover', 'restly' ),
            'output'     => '.header-two .header-top ul li a',
            'default'    => array(
                'color' => '#ffffff',
                'hover' => '#104cba',
            ),
            'dependency' => array( 'restly_header_styles|restly_show_top_header2', '==|==', 'two|true', 'all' ),
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'success',
            'content'    => esc_html__( 'Menu Section Options', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'two', 'all' ),
        ),
        array(
            'id'         => 'restly_top_header2_menu_ncolors',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Menu Color', 'restly' ),
            'subtitle'   => esc_html__( 'Nav Menu Normal and Hover Color', 'restly' ),
            'output'     => '.header-two .main-navigation ul li a',
            'dependency' => array( 'restly_header_styles', '==', 'two', 'all' ),
            'default'    => array(
                'color' => '#ffffff',
                'hover' => '#b0c2d7',
            ),
        ),
        array(
            'id'         => 'restly_header2_menu_bg',
            'type'       => 'background',
            'title'      => esc_html__( 'Background', 'restly' ),
            'subtitle'   => esc_html__( 'Add Background Color for Menu Area', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'two', 'all' ),
            'output'     => '.header-two .main-header.header-fluid',
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'Sub menu Options', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'two', 'all' ),
        ),
        array(
            'id'         => 'restly_header2_menu_bg',
            'type'       => 'color_group',
            'title'      => esc_html__( 'Sub menu Colors', 'restly' ),
            'subtitle'   => esc_html__( 'Add SubMenu Color', 'restly' ),
            'options'    => array(
                'restly_hea2_submeni_bgc'     => esc_html__( 'Box Background', 'restly' ),
                'restly_hea2_submeni_textc'   => esc_html__( 'Text Color', 'restly' ),
                'restly_hea2_submeni_texthc'  => esc_html__( 'Text Hover/active Color', 'restly' ),
                'restly_hea2_submeni_texthbg' => esc_html__( 'Hover/active BG Color', 'restly' ),
            ),
            'default'    => array(
                'restly_hea2_submeni_bgc'     => '#ffffff',
                'restly_hea2_submeni_textc'   => '#1d2c38',
                'restly_hea2_submeni_texthc'  => '#ffffff',
                'restly_hea2_submeni_texthbg' => '#104cba',
            ),
            'dependency' => array( 'restly_header_styles', '==', 'two', 'all' ),
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'CTA Button Option', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'two', 'all' ),
        ),
        array(
            'id'         => 'restly_show_cta2',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable CTA Button', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Header CTA button if you need', 'restly' ),
            'default'    => true,
            'dependency' => array( 'restly_header_styles', '==', 'two', 'all' ),
        ),
        array(
            'id'          => 'restly_cta_bg2',
            'type'        => 'color',
            'title'       => esc_html__( 'CTA Button Bg', 'restly' ),
            'subtitle'    => esc_html__( 'Add CTA Button Background Color', 'restly' ),
            'default'     => '#104cba',
            'output'      => '.header-two .button .theme-btns',
            'output_mode' => 'background-color',
            'dependency'  => array( 'restly_header_styles|restly_show_cta2', '==|==', 'two|true', 'all' ),
        ),
        array(
            'id'          => 'restly_cta_bgh2',
            'type'        => 'color',
            'title'       => esc_html__( 'CTA Button Hover Bg', 'restly' ),
            'subtitle'    => esc_html__( 'Add CTA Button Hover Background Color', 'restly' ),
            'default'     => '#1d2c38',
            'output'      => '.header-two .button .theme-btns:hover',
            'output_mode' => 'background-color',
            'dependency'  => array( 'restly_header_styles|restly_show_cta2', '==|==', 'two|true', 'all' ),
        ),
        array(
            'id'         => 'restly_cta2_text_color',
            'type'       => 'link_color',
            'title'      => esc_html__( 'CTA Button Text Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add CTA Button Text Hover and Normal Color', 'restly' ),
            'output'     => '.header-two .button .theme-btns',
            'dependency' => array( 'restly_header_styles|restly_show_cta2', '==|==', 'two|true', 'all' ),
            'default'    => array(
                'color' => '#ffffff',
                'hover' => '#ffffff',
            ),
        ),
        /////////////////////////
        // Header Three ////////
        ///////////////////////
        array(
            'id'         => 'restly_show_hlogo3',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Logo', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Logo Options if you need', 'restly' ),
            'default'    => true,
            'dependency' => array( 'restly_header_styles', '==', 'three', 'all' ),
        ),
        array(
            'id'         => 'restly_logo3',
            'type'       => 'media',
            'title'      => esc_html__( 'SIte Logo', 'restly' ),
            'subtitle'   => esc_html__( 'Upload Header Logo if you do not use Wordpress Default logo option ', 'restly' ),
            'library'    => 'image',
            'dependency' => array( 'restly_header_styles|restly_show_hlogo3', '==|==', 'three|true', 'all' ),
        ),
        array(
            'id'          => 'restly_logo3_size',
            'type'        => 'number',
            'title'       => esc_html__( 'Logo Size', 'restly' ),
            'subtitle'       => esc_html__( 'Add logo Size if you need Logo Size', 'restly' ),
            'unit'        => 'px',
            'output'      => '.header-three .site-branding img',
            'output_mode' => 'width',
            'dependency'  => array( 'restly_header_styles', '==', 'three', 'all' ),
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'success',
            'content'    => esc_html__( 'Top Header Options', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'three', 'all' ),
        ),
        array(
            'id'         => 'restly_show_top_header3',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Top Header', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Top Header Option', 'restly' ),
            'default'    => true,
            'dependency' => array( 'restly_header_styles', '==', 'three', 'all' ),
        ),
        array(
            'id'         => 'restly_top_header3_bg',
            'type'       => 'background',
            'title'      => esc_html__( 'Background', 'restly' ),
            'subtitle'   => esc_html__( 'Add Background Color or Image', 'restly' ),
            'dependency' => array( 'restly_header_styles|restly_show_top_header3', '==|', 'three|true', 'all' ),
            'default'    => array(
                'background-color' => '#104cba',
            ),
            'output'     => '.header-three .header-top',
        ),
        array(
            'id'         => 'restly_top_header3_label_c',
            'type'       => 'color',
            'title'      => esc_html__( 'Label Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Header top Label', 'restly' ),
            'default'    => '#ffffff',
            'dependency' => array( 'restly_header_styles|restly_show_top_header3', '==|', 'three|true', 'all' ),
            'output'     => '.header-three .header-top ul li span',
        ),
        array(
            'id'         => 'restly_top_header3_text_c',
            'type'       => 'color',
            'title'      => esc_html__( 'Text Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Header top Content', 'restly' ),
            'default'    => '#ffffff',
            'output'     => '.header-three .header-top ul li',
            'dependency' => array( 'restly_header_styles|restly_show_top_header2', '==|', 'three|true', 'all' ),
        ),
        array(
            'id'         => 'restly_top_header3_icon_c',
            'type'       => 'color',
            'title'      => esc_html__( 'Icon Color', 'restly' ),
            'subtitle'   => esc_html__( 'Withour Link Icon Color', 'restly' ),
            'default'    => '#ffffff',
            'output'     => '.header-three .office-time i',
            'dependency' => array( 'restly_header_styles|restly_show_top_header3', '==|', 'three|true', 'all' ),
        ),
        array(
            'id'         => 'restly_top_header3_link_c',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Link Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Header top Links Normal and Hover', 'restly' ),
            'output'     => '.header-three .header-top ul li a',
            'default'    => array(
                'color' => '#ffffff',
                'hover' => '#1d2c38',
            ),
            'dependency' => array( 'restly_header_styles|restly_show_top_header3', '==|', 'three|true', 'all' ),
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'success',
            'content'    => esc_html__( 'Menu Section Options', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'three', 'all' ),
        ),
        array(
            'id'         => 'restly_top_header3_menu_ncolors',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Menu Color', 'restly' ),
            'subtitle'   => esc_html__( 'Nav Menu Normal and Hover Color', 'restly' ),
            'output'     => '.header-three .main-navigation ul li a',
            'dependency' => array( 'restly_header_styles', '==', 'three', 'all' ),
            'default'    => array(
                'color' => '#ffffff',
                'hover' => '#b0c2d7',
            ),
        ),
        array(
            'id'          => 'restly_header3_border_color',
            'type'        => 'color',
            'title'       => esc_html__( 'Border Color', 'restly' ),
            'subtitle'    => esc_html__( 'Add Header Border Color', 'restly' ),
            'dependency'  => array( 'restly_header_styles', '==', 'three', 'all' ),
            'output_mode' => 'border-color',
            'output'      => '.header-three .main-header',
        ),
        array(
            'id'         => 'restly_header3_menu_bg',
            'type'       => 'background',
            'title'      => esc_html__( 'Background', 'restly' ),
            'subtitle'   => esc_html__( 'Add Background Color for Menu Area', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'three', 'all' ),
            'output'     => '.header-three .header-three .main-header.header-fluid .navbar',
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'Sub menu Options', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'three', 'all' ),
        ),
        array(
            'id'         => 'restly_header3_smenu_bg',
            'type'       => 'color_group',
            'title'      => esc_html__( 'Sub menu Colors', 'restly' ),
            'subtitle'   => esc_html__( 'Add SubMenu Color', 'restly' ),
            'options'    => array(
                'restly_hea3_submeni_bgc'     => esc_html__( 'Box Background', 'restly' ),
                'restly_hea3_submeni_textc'   => esc_html__( 'Text Color', 'restly' ),
                'restly_hea3_submeni_texthc'  => esc_html__( 'Text Hover/active Color', 'restly' ),
                'restly_hea3_submeni_texthbg' => esc_html__( 'Hover/active BG Color', 'restly' ),
            ),
            'default'    => array(
                'restly_hea3_submeni_bgc'     => '#ffffff',
                'restly_hea3_submeni_textc'   => '#1d2c38',
                'restly_hea3_submeni_texthc'  => '#ffffff',
                'restly_hea3_submeni_texthbg' => '#104cba',
            ),
            'dependency' => array( 'restly_header_styles', '==', 'three', 'all' ),
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'CTA Button Option', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'three', 'all' ),
        ),
        array(
            'id'         => 'restly_show_cta3',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable CTA Button', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Header CTA button if you need', 'restly' ),
            'default'    => true,
            'dependency' => array( 'restly_header_styles', '==', 'three', 'all' ),
        ),
        array(
            'id'          => 'restly_cta_bg3',
            'type'        => 'color',
            'title'       => esc_html__( 'CTA Button Bg', 'restly' ),
            'subtitle'    => esc_html__( 'Add CTA Button Background Color', 'restly' ),
            'default'     => '#104cba',
            'output'      => '.header-three .button .theme-btns',
            'output_mode' => 'background-color',
            'dependency'  => array( 'restly_header_styles|restly_show_cta3', '==|==', 'three|true', 'all' ),
        ),
        array(
            'id'          => 'restly_cta_bgh3',
            'type'        => 'color',
            'title'       => esc_html__( 'CTA Button Hover Bg', 'restly' ),
            'subtitle'    => esc_html__( 'Add CTA Button Hover Background Color', 'restly' ),
            'default'     => '#1d2c38',
            'output'      => '.header-three .button .theme-btns:hover',
            'output_mode' => 'background-color',
            'dependency'  => array( 'restly_header_styles|restly_show_cta3', '==|==', 'three|true', 'all' ),
        ),
        array(
            'id'         => 'restly_cta3_text_color',
            'type'       => 'link_color',
            'title'      => esc_html__( 'CTA Button Text Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add CTA Button Text Hover and Normal Color', 'restly' ),
            'output'     => '.header-three .button .theme-btns',
            'dependency' => array( 'restly_header_styles|restly_show_cta3', '==|==', 'three|true', 'all' ),
            'default'    => array(
                'color' => '#ffffff',
                'hover' => '#ffffff',
            ),
        ),
        /////////////////////////
        // Header four ////////
        ///////////////////////
        array(
            'id'         => 'restly_show_hlogo4',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Logo', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Logo Options if you need', 'restly' ),
            'default'    => true,
            'dependency' => array( 'restly_header_styles', '==', 'four', 'all' ),
        ),
        array(
            'id'         => 'restly_logo4',
            'type'       => 'media',
            'title'      => esc_html__( 'SIte Logo', 'restly' ),
            'subtitle'   => esc_html__( 'Upload Header Logo if you do not use Wordpress Default logo option ', 'restly' ),
            'library'    => 'image',
            'dependency' => array( 'restly_header_styles|restly_show_hlogo4', '==|==', 'four|true', 'all' ),
        ),
        array(
            'id'          => 'restly_logo4_size',
            'type'        => 'number',
            'title'       => esc_html__( 'Logo Size', 'restly' ),
            'subtitle'       => esc_html__( 'Add logo Size if you need Logo Size', 'restly' ),
            'unit'        => 'px',
            'output'      => '.header-three.header-four .site-branding img',
            'output_mode' => 'width',
            'dependency'  => array( 'restly_header_styles', '==', 'four', 'all' ),
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'success',
            'content'    => esc_html__( 'Top Header Options', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'four', 'all' ),
        ),
        array(
            'id'         => 'restly_show_top_header4',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Top Header', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Top Header Option', 'restly' ),
            'default'    => true,
            'dependency' => array( 'restly_header_styles', '==', 'four', 'all' ),
        ),
        array(
            'id'         => 'restly_top_header4_bg',
            'type'       => 'background',
            'title'      => esc_html__( 'Background', 'restly' ),
            'subtitle'   => esc_html__( 'Add Background Color or Image', 'restly' ),
            'dependency' => array( 'restly_header_styles|restly_show_top_header4', '==|', 'four|true', 'all' ),
            'default'    => array(
                'background-color' => '#e5eef6',
            ),
            'output'     => '.header-three.header-three.header-four .header-top',
        ),
        array(
            'id'         => 'restly_top_header4_label_c',
            'type'       => 'color',
            'title'      => esc_html__( 'Label Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Header top Label', 'restly' ),
            'default'    => '#1d2c38',
            'dependency' => array( 'restly_header_styles|restly_show_top_header4', '==|', 'four|true', 'all' ),
            'output'     => '.header-three.header-three.header-four .header-top ul li span',
        ),
        array(
            'id'         => 'restly_top_header4_text_c',
            'type'       => 'color',
            'title'      => esc_html__( 'Text Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Header top Content', 'restly' ),
            'output'     => '.header-three.header-three.header-four .header-top ul li',
            'dependency' => array( 'restly_header_styles|restly_show_top_header4', '==|', 'four|true', 'all' ),
        ),
        array(
            'id'         => 'restly_top_header4_icon_c',
            'type'       => 'color',
            'title'      => esc_html__( 'Icon Color', 'restly' ),
            'subtitle'   => esc_html__( 'Withour Link Icon Color', 'restly' ),
            'output'     => '.header-three.header-four .office-time i',
            'dependency' => array( 'restly_header_styles|restly_show_top_header4', '==|', 'four|true', 'all' ),
        ),
        array(
            'id'         => 'restly_top_header4_link_c',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Link Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Header top Links Normal and Hover', 'restly' ),
            'output'     => '.header-three.header-four .header-top ul li a',
            'dependency' => array( 'restly_header_styles|restly_show_top_header4', '==|', 'four|true', 'all' ),
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'success',
            'content'    => esc_html__( 'Menu Section Options', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'four', 'all' ),
        ),
        array(
            'id'         => 'restly_top_header4_menu_ncolors',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Menu Color', 'restly' ),
            'subtitle'   => esc_html__( 'Nav Menu Normal and Hover Color', 'restly' ),
            'output'     => '.header-three.header-four .main-navigation ul li a',
            'dependency' => array( 'restly_header_styles', '==', 'four', 'all' ),
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'Sub menu Options', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'four', 'all' ),
        ),
        array(
            'id'         => 'restly_header4_menu_submenu',
            'type'       => 'color_group',
            'title'      => esc_html__( 'Sub menu Colors', 'restly' ),
            'subtitle'   => esc_html__( 'Add SubMenu Color', 'restly' ),
            'options'    => array(
                'restly_hea4_submeni_bgc'     => esc_html__( 'Box Background', 'restly' ),
                'restly_hea4_submeni_textc'   => esc_html__( 'Text Color', 'restly' ),
                'restly_hea4_submeni_texthc'  => esc_html__( 'Text Hover/active Color', 'restly' ),
                'restly_hea4_submeni_texthbg' => esc_html__( 'Hover/active BG Color', 'restly' ),
            ),
            'dependency' => array( 'restly_header_styles', '==', 'four', 'all' ),
        ),
        // Search 
        array(
            'id'         => 'restly_show_search4',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Search Icon', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Search Icon if you need', 'restly' ),
            'default'    => true,
            'dependency' => array( 'restly_header_styles', '==', 'four', 'all' ),
        ),
        array(
            'id'         => 'restly_search4_icon_c',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Icon Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add normal and hover colar for header search icon', 'restly' ),
            'output'     => '.header-four .button.search-open',
            'dependency' => array(
                array( 'restly_show_search4', '==', 'true' ),
                array( 'restly_header_styles',   '==', 'four','all' ),
            ),
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'CTA Button Option', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'four', 'all' ),
        ),
        array(
            'id'         => 'restly_show_cta4',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable CTA Button', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Header CTA button if you need', 'restly' ),
            'default'    => true,
            'dependency' => array( 'restly_header_styles', '==', 'four', 'all' ),
        ),
        array(
            'id'          => 'restly_cta_bg4',
            'type'        => 'color',
            'title'       => esc_html__( 'CTA Button Bg', 'restly' ),
            'subtitle'    => esc_html__( 'Add CTA Button Background Color', 'restly' ),
            'output'      => '.header-three.header-four .button .theme-btns',
            'output_mode' => 'background-color',
            'dependency'  => array( 'restly_header_styles|restly_show_cta4', '==|==', 'four|true', 'all' ),
        ),
        array(
            'id'          => 'restly_cta_bgh4',
            'type'        => 'color',
            'title'       => esc_html__( 'CTA Button Hover Bg', 'restly' ),
            'subtitle'    => esc_html__( 'Add CTA Button Hover Background Color', 'restly' ),
            'output'      => '.header-three.header-four .button .theme-btns:hover',
            'output_mode' => 'background-color',
            'dependency'  => array( 'restly_header_styles|restly_show_cta4', '==|==', 'four|true', 'all' ),
        ),
        array(
            'id'         => 'restly_cta4_text_color',
            'type'       => 'link_color',
            'title'      => esc_html__( 'CTA Button Text Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add CTA Button Text Hover and Normal Color', 'restly' ),
            'output'     => '.header-three.header-four .button .theme-btns',
            'dependency' => array( 'restly_header_styles|restly_show_cta4', '==|==', 'four|true', 'all' ),
        ),
    /////////////////////////
    // Header five ////////
    ///////////////////////
        array(
            'id'         => 'restly_show_hlogo5',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Logo', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Logo Options if you need', 'restly' ),
            'default'    => true,
            'dependency' => array( 'restly_header_styles', '==', 'five', 'all' ),
        ),
        array(
            'id'         => 'restly_logo5',
            'type'       => 'media',
            'title'      => esc_html__( 'SIte Logo', 'restly' ),
            'subtitle'   => esc_html__( 'Upload Header Logo if you do not use Wordpress Default logo option ', 'restly' ),
            'library'    => 'image',
            'dependency' => array( 'restly_header_styles|restly_show_hlogo5', '==|==', 'five|true', 'all' ),
        ),
        array(
            'id'          => 'restly_logo5_size',
            'type'        => 'number',
            'title'       => esc_html__( 'Logo Size', 'restly' ),
            'subtitle'       => esc_html__( 'Add logo Size if you need Logo Size', 'restly' ),
            'unit'        => 'px',
            'output'      => '.header-three.header-five .site-branding img',
            'output_mode' => 'width',
            'dependency'  => array( 'restly_header_styles', '==', 'five', 'all' ),
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'success',
            'content'    => esc_html__( 'Top Header Options', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'five', 'all' ),
        ),
        array(
            'id'         => 'restly_show_top_header5',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Top Header', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Top Header Option', 'restly' ),
            'default'    => true,
            'dependency' => array( 'restly_header_styles', '==', 'five', 'all' ),
        ),
        array(
            'id'         => 'restly_top_header5_bg',
            'type'       => 'background',
            'title'      => esc_html__( 'Background', 'restly' ),
            'subtitle'   => esc_html__( 'Add Background Color or Image', 'restly' ),
            'dependency' => array( 'restly_header_styles|restly_show_top_header5', '==|==', 'five|true', 'all' ),
            'default'    => array(
                'background-color' => '#e5eef6',
            ),
            'output'     => '.header-three.header-three.header-five .header-top',
        ),
        array(
            'id'         => 'restly_top_header5_label_c',
            'type'       => 'color',
            'title'      => esc_html__( 'Label Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Header top Label', 'restly' ),
            'default'    => '#1d2c38',
            'dependency' => array( 'restly_header_styles|restly_show_top_header5', '==|==', 'five|true', 'all' ),
            'output'     => '.header-three.header-three.header-five .header-top ul li span',
        ),
        array(
            'id'         => 'restly_top_header5_text_c',
            'type'       => 'color',
            'title'      => esc_html__( 'Text Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Header top Content', 'restly' ),
            'output'     => '.header-three.header-three.header-five .header-top ul li',
            'dependency' => array( 'restly_header_styles|restly_show_top_header5', '==|==', 'five|true', 'all' ),
        ),
        array(
            'id'         => 'restly_top_header5_icon_c',
            'type'       => 'color',
            'title'      => esc_html__( 'Icon Color', 'restly' ),
            'subtitle'   => esc_html__( 'Withour Link Icon Color', 'restly' ),
            'output'     => '.header-three.header-five .office-time i',
            'dependency' => array( 'restly_header_styles|restly_show_top_header5', '==|==', 'five|true', 'all' ),
        ),
        array(
            'id'         => 'restly_top_header5_link_c',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Link Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Header top Links Normal and Hover', 'restly' ),
            'output'     => '.header-three.header-five .header-top ul li a',
            'dependency' => array( 'restly_header_styles|restly_show_top_header5', '==|==', 'five|true', 'all' ),
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'success',
            'content'    => esc_html__( 'Menu Section Options', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'five', 'all' ),
        ),
        array(
            'id'         => 'restly_top_header5_menu_ncolors',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Menu Color', 'restly' ),
            'subtitle'   => esc_html__( 'Nav Menu Normal and Hover Color', 'restly' ),
            'output'     => '.header-three.header-five .main-navigation > div > ul > li > a',
            'dependency' => array( 'restly_header_styles', '==', 'five', 'all' ),
            'default' => array(
                'color' => '#1d2c38',
                'hover' => '#104cba',
            ),
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'Sub menu Options', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'five', 'all' ),
        ),
        array(
            'id'         => 'restly_header5_menu_submenu',
            'type'       => 'color_group',
            'title'      => esc_html__( 'Sub menu Colors', 'restly' ),
            'subtitle'   => esc_html__( 'Add SubMenu Color', 'restly' ),
            'options'    => array(
                'restly_hea5_submeni_bgc'     => esc_html__( 'Box Background', 'restly' ),
                'restly_hea5_submeni_textc'   => esc_html__( 'Text Color', 'restly' ),
                'restly_hea5_submeni_texthc'  => esc_html__( 'Text Hover/active Color', 'restly' ),
                'restly_hea5_submeni_texthbg' => esc_html__( 'Hover/active BG Color', 'restly' ),
            ),
            'dependency' => array( 'restly_header_styles', '==', 'five', 'all' ),
        ),

        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'Search Option', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'five', 'all' ),
        ),
        // Search 
        array(
            'id'         => 'restly_show_search5',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Search Icon', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Search Icon if you need', 'restly' ),
            'default'    => true,
            'dependency' => array( 'restly_header_styles', '==', 'five', 'all' ),
        ),
        array(
            'id'         => 'restly_search5_icon_c',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Icon Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add normal and hover colar for header search icon', 'restly' ),
            'output'     => '.header-five .button.search-open',
            'dependency' => array(
                array( 'restly_show_search5', '==', 'true' ),
                array( 'restly_header_styles',   '==', 'five','all' ),
            ),
        ),
        
        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'CTA Button Option', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'five', 'all' ),
        ),
        array(
            'id'         => 'restly_show_cta5',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable CTA Button', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Header CTA button if you need', 'restly' ),
            'default'    => true,
            'dependency' => array( 'restly_header_styles', '==', 'five', 'all' ),
        ),
        array(
            'id'          => 'restly_cta_bg5',
            'type'        => 'color',
            'title'       => esc_html__( 'CTA Button Bg', 'restly' ),
            'subtitle'    => esc_html__( 'Add CTA Button Background Color', 'restly' ),
            'output'      => '.header-three.header-five .button .theme-btns',
            'output_mode' => 'background-color',
            'dependency'  => array( 'restly_header_styles|restly_show_cta5', '==|==', 'five|true', 'all' ),
        ),
        array(
            'id'          => 'restly_cta_bgh5',
            'type'        => 'color',
            'title'       => esc_html__( 'CTA Button Hover Bg', 'restly' ),
            'subtitle'    => esc_html__( 'Add CTA Button Hover Background Color', 'restly' ),
            'output'      => '.header-three.header-five .button .theme-btns:hover',
            'output_mode' => 'background-color',
            'dependency'  => array( 'restly_header_styles|restly_show_cta5', '==|==', 'five|true', 'all' ),
        ),
        array(
            'id'         => 'restly_cta5_text_color',
            'type'       => 'link_color',
            'title'      => esc_html__( 'CTA Button Text Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add CTA Button Text Hover and Normal Color', 'restly' ),
            'output'     => '.header-three.header-five .button .theme-btns',
            'dependency' => array( 'restly_header_styles|restly_show_cta5', '==|==', 'five|true', 'all' ),
        ),

        /////////////////////////
        // Header six ////////
        ///////////////////////
        array(
            'id'         => 'restly_show_hlogo6',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Logo', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Logo Options if you need', 'restly' ),
            'default'    => true,
            'dependency' => array( 'restly_header_styles', '==', 'six', 'all' ),
        ),
        array(
            'id'         => 'restly_logo6',
            'type'       => 'media',
            'title'      => esc_html__( 'SIte Logo', 'restly' ),
            'subtitle'   => esc_html__( 'Upload Header Logo if you do not use Wordpress Default logo option ', 'restly' ),
            'library'    => 'image',
            'dependency' => array( 'restly_header_styles|restly_show_hlogo6', '==|==', 'six|true', 'all' ),
        ),
        array(
            'id'          => 'restly_header6_border_color',
            'type'        => 'color',
            'title'       => esc_html__( 'Border Color', 'restly' ),
            'subtitle'    => esc_html__( 'Add Header Border Color', 'restly' ),
            'default'     => 'rgba(0,0,0,0)',
            'dependency'  => array( 'restly_header_styles', '==', 'six', 'all' ),
            'output_mode' => 'border-color',
            'output'      => '.header-six .main-header',
        ),
        array(
            'id'          => 'restly_logo6_size',
            'type'        => 'number',
            'title'       => esc_html__( 'Logo Size', 'restly' ),
            'subtitle'       => esc_html__( 'Add logo Size if you need Logo Size', 'restly' ),
            'unit'        => 'px',
            'output'      => '.header-six .site-branding img',
            'output_mode' => 'width',
            'dependency'  => array( 'restly_header_styles', '==', 'six', 'all' ),
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'success',
            'content'    => esc_html__( 'Menu Section Options', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'six', 'all' ),
        ),
        array(
            'id'         => 'restly_top_header6_menu_ncolors',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Menu Color', 'restly' ),
            'subtitle'   => esc_html__( 'Nav Menu Normal and Hover Color', 'restly' ),
            'output'     => '.header-six .main-navigation ul li a',
            'dependency' => array( 'restly_header_styles', '==', 'six', 'all' ),
        ),
        array(
            'id'         => 'restly_header6_menu_bgcolor',
            'type'       => 'color',
            'title'      => esc_html__( 'Background Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Background Color for header', 'restly' ),
            'output'      => '.header-six .main-header',
            'output_mode' => 'background-color',
            'dependency' => array( 'restly_header_styles', '==', 'six', 'all' ),
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'Sub menu Options', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'six', 'all' ),
        ),
        array(
            'id'         => 'restly_header6_menu_submenu',
            'type'       => 'color_group',
            'title'      => esc_html__( 'Sub menu Colors', 'restly' ),
            'subtitle'   => esc_html__( 'Add SubMenu Color', 'restly' ),
            'options'    => array(
                'restly_hea6_submeni_bgc'     => esc_html__( 'Box Background', 'restly' ),
                'restly_hea6_submeni_textc'   => esc_html__( 'Text Color', 'restly' ),
                'restly_hea6_submeni_texthc'  => esc_html__( 'Text Hover/active Color', 'restly' ),
                'restly_hea6_submeni_texthbg' => esc_html__( 'Hover/active BG Color', 'restly' ),
            ),
            'dependency' => array( 'restly_header_styles', '==', 'six', 'all' ),
        ),
        
        // Search 
        array(
            'id'         => 'restly_show_search6',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Search Icon', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Search Icon if you need', 'restly' ),
            'default'    => true,
            'dependency' => array( 'restly_header_styles', '==', 'six', 'all' ),
        ),
        array(
            'id'         => 'restly_search6_icon_c',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Icon Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add normal and hover colar for header search icon', 'restly' ),
            'output'     => '.header-six .button.search-open',
            'dependency' => array(
                array( 'restly_show_search6', '==', 'true' ),
                array( 'restly_header_styles',   '==', 'six','all' ),
            ),
        ),
        // Login
        array(
            'id'         => 'restly_show_login6',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Login Button', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Login/Signup Button if you need', 'restly' ),
            'default'    => true,
            'dependency' => array( 'restly_header_styles', '==', 'six', 'all' ),
        ),
        array(
            'id'      => 'restly_show_login_text',
            'type'    => 'text',
            'title'   => esc_html__( 'Add Button Text', 'restly' ),
            'subtitle'=> esc_html__( 'Add Login/SignUp Button Text', 'restly' ),
            'default' => esc_html__( 'Login/SignUp', 'restly' ),
            'dependency' => array( 'restly_header_styles|restly_show_login6', '==|==', 'six|true', 'all' ),
        ),
        array(
            'id'         => 'restly_show_clogin6',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Custom Login link', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Login/Signup link if you need', 'restly' ),
            'default'    => false,
            'dependency' => array( 'restly_header_styles|restly_show_login6', '==|==', 'six|true', 'all' ),
        ),
        array(
            'id'      => 'restly_clogin_link',
            'type'    => 'text',
            'title'   => esc_html__( 'Add Button Link', 'restly' ),
            'subtitle'=> esc_html__( 'Add Login/SignUp Button Custom Link', 'restly' ),
            'dependency' => array( 'restly_header_styles|restly_show_login6', '==|==', 'six|true', 'all' ),
        ),
        array(
            'id'        => 'restly_login6_colors',
            'type'      => 'color_group',
            'title'   => esc_html__( 'Add Colors', 'restly' ),
            'title'   => esc_html__( 'Add Colors for login button', 'restly' ),
            'dependency' => array( 'restly_header_styles|restly_show_login6', '==|==', 'six|true', 'all' ),
            'options'   => array(
              'restly_login6_bocolor' => esc_html__( 'Border Color', 'restly' ),
              'restly_login6_bgcolor' => esc_html__( 'Background Color', 'restly' ),
              'restly_login6_tcolor' => esc_html__( 'Text Color', 'restly' ),
              'restly_login6_hbocolor' => esc_html__( 'Hover Border Color', 'restly' ),
              'restly_login6_hbgcolor' => esc_html__( 'Hover Background Color', 'restly' ),
              'restly_login6_htcolor' => esc_html__( 'Hover Text Color', 'restly' ),
            )
        ),
        // Header Cart
        array(
            'id'         => 'restly_show_minicart',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Minicart', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Minicart if you need', 'restly' ),
            'default'    => true,
            'dependency' => array( 'restly_header_styles', '==', 'six', 'all' ),
        ),
        array(
            'id'         => 'restly_minicart_icon',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Icon Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add normal and hover colar for header Minicart Color', 'restly' ),
            'output'     => '.header-six .restly-hmini a span.fas',
            'dependency' => array( 'restly_show_minicart|restly_header_styles', '==|==', 'true|six','all' ),
        ),
        /////////////////////////
        // Header seven ////////
        ///////////////////////
        array(
            'id'         => 'restly_show_hlogo7',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Logo', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Logo Options if you need', 'restly' ),
            'default'    => true,
            'dependency' => array( 'restly_header_styles', '==', 'seven', 'all' ),
        ),
        array(
            'id'         => 'restly_logo7',
            'type'       => 'media',
            'title'      => esc_html__( 'SIte Logo', 'restly' ),
            'subtitle'   => esc_html__( 'Upload Header Logo if you do not use Wordpress Default logo option ', 'restly' ),
            'library'    => 'image',
            'dependency' => array( 'restly_header_styles|restly_show_hlogo7', '==|==', 'seven|true', 'all' ),
        ),
        array(
            'id'          => 'restly_logo7_size',
            'type'        => 'number',
            'title'       => esc_html__( 'Logo Size', 'restly' ),
            'subtitle'       => esc_html__( 'Add logo Size if you need Logo Size', 'restly' ),
            'unit'        => 'px',
            'output'      => '.header-seven .site-branding img',
            'output_mode' => 'width',
            'dependency'  => array( 'restly_header_styles', '==', 'seven', 'all' ),
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'success',
            'content'    => esc_html__( 'Menu Section Options', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'seven', 'all' ),
        ),
        array(
            'id'         => 'restly_top_header7_menu_ncolors',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Menu Color', 'restly' ),
            'subtitle'   => esc_html__( 'Nav Menu Normal and Hover Color', 'restly' ),
            'output'     => '.header-seven .main-navigation ul li a',
            'dependency' => array( 'restly_header_styles', '==', 'seven', 'all' ),
        ),
        array(
            'id'          => 'restly_header7_border_color',
            'type'        => 'color',
            'title'       => esc_html__( 'Border Color', 'restly' ),
            'subtitle'    => esc_html__( 'Add Header Border Color', 'restly' ),
            'dependency'  => array( 'restly_header_styles', '==', 'seven', 'all' ),
            'output_mode' => 'border-color',
            'output'      => '.header-seven .main-header',
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'Sub menu Options', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'seven', 'all' ),
        ),
        array(
            'id'         => 'restly_header7_menu_submenu',
            'type'       => 'color_group',
            'title'      => esc_html__( 'Sub menu Colors', 'restly' ),
            'subtitle'   => esc_html__( 'Add SubMenu Color', 'restly' ),
            'options'    => array(
                'restly_hea7_submeni_bgc'     => esc_html__( 'Box Background', 'restly' ),
                'restly_hea7_submeni_textc'   => esc_html__( 'Text Color', 'restly' ),
                'restly_hea7_submeni_texthc'  => esc_html__( 'Text Hover/active Color', 'restly' ),
                'restly_hea7_submeni_texthbg' => esc_html__( 'Hover/active BG Color', 'restly' ),
            ),
            'dependency' => array( 'restly_header_styles', '==', 'seven', 'all' ),
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'success',
            'content'    => esc_html__( 'Contact Button', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'seven', 'all' ),
        ),
        array(
            'id'         => 'restly_header7_con_enalbe',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Contact', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Contact Options if you need', 'restly' ),
            'default'    => true,
            'dependency' => array( 'restly_header_styles', '==', 'seven', 'all' ),
        ),
        array(
            'id'      => 'restly_header7_contact_label',
            'type'    => 'text',
            'title'   => esc_html__( 'Label', 'restly' ),
            'subtitle'   => esc_html__( 'Add Title for Contact Number', 'restly' ),
            'default' => esc_html__( 'Tell Us', 'restly' ),
            'dependency' => array( 'restly_header_styles|restly_header7_con_enalbe', '==|==', 'seven|true', 'all' ),
        ),
        array(
            'id'      => 'restly_header7_contact_number',
            'type'    => 'text',
            'title'   => esc_html__( 'Contact Number', 'restly' ),
            'subtitle'   => esc_html__( 'Add Number for Disply', 'restly' ),
            'default' => esc_html__( '+12-235-586-56', 'restly' ),
            'dependency' => array( 'restly_header_styles|restly_header7_con_enalbe', '==|==', 'seven|true', 'all' ),
        ),
        array(
            'id'      => 'restly_header7_contact_number_link',
            'type'    => 'text',
            'title'   => esc_html__( 'Contact Number', 'restly' ),
            'subtitle'   => esc_html__( 'Add Number For Link', 'restly' ),
            'default' => esc_html__( '+1223558656', 'restly' ),
            'dependency' => array( 'restly_header_styles|restly_header7_con_enalbe', '==|==', 'seven|true', 'all' ),
        ),
        array(
            'id'      => 'restly_header7_contact_icon',
            'type'    => 'icon',
            'title'   => esc_html__( 'Icon', 'restly' ),
            'subtitle'   => esc_html__( 'Add Icon here', 'restly' ),
            'default' => 'fas fa-phone-alt',
            'dependency' => array( 'restly_header_styles|restly_header7_con_enalbe', '==|==', 'seven|true', 'all' ),
        ),
        array(
            'id'     => 'restly_header7_ccolor_group',
            'type'   => 'fieldset',
            'title'  => esc_html__( 'Contact CSS Options', 'restly' ),
            'subtitle'  => esc_html__( 'Add CSS for Contact Button', 'restly' ),
            'dependency' => array( 'restly_header_styles|restly_header7_con_enalbe', '==|==', 'seven|true', 'all' ),
            'fields' => array(
                array(
                    'type'       => 'submessage',
                    'style'      => 'success',
                    'content'    => esc_html__( 'ICON CSS SETTINGS', 'restly' ),
                ),
                array(
                    'id'          => 'restly_h7_ccolor',
                    'type'        => 'color',
                    'title'       => esc_html__( 'icon Color', 'restly' ),
                    'subtitle'    => esc_html__( 'Add contact icon Color', 'restly' ),
                    'dependency'  => array( 'restly_header_styles', '==', 'seven', 'all' ),
                    'output_mode' => 'color',
                    'output'      => '.header-seven .header-number > i',
                ),
                array(
                    'id'          => 'restly_h7_cbcolor',
                    'type'        => 'color',
                    'title'       => esc_html__( 'background Color', 'restly' ),
                    'subtitle'    => esc_html__( 'Add contact icon Color', 'restly' ),
                    'dependency'  => array( 'restly_header_styles', '==', 'seven', 'all' ),
                    'output_mode' => 'background-color',
                    'output'      => '.header-seven .header-number > i',
                ),
                array(
                    'id'          => 'restly_h7_cbocolor',
                    'type'        => 'color',
                    'title'       => esc_html__( 'Border Color', 'restly' ),
                    'subtitle'    => esc_html__( 'Add contact Border Color', 'restly' ),
                    'dependency'  => array( 'restly_header_styles', '==', 'seven', 'all' ),
                    'output_mode' => 'border-color',
                    'output'      => '.header-seven .header-number > i',
                ),
                array(
                    'type'       => 'submessage',
                    'style'      => 'success',
                    'content'    => esc_html__( 'BUTTON LABEL CSS SETTINGS', 'restly' ),
                ),
                array(
                    'id'          => 'restly_h7_cl_c',
                    'type'        => 'color',
                    'title'       => esc_html__( 'Label Color', 'restly' ),
                    'subtitle'    => esc_html__( 'Add contact Label Color', 'restly' ),
                    'dependency'  => array( 'restly_header_styles', '==', 'seven', 'all' ),
                    'output_mode' => 'color',
                    'output'      => '.header-seven .header-number .number-content span',
                ),
                array(
                    'type'       => 'submessage',
                    'style'      => 'success',
                    'content'    => esc_html__( 'BUTTON LINK CSS SETTINGS', 'restly' ),
                ),
                array(
                    'id'    => 'restly_h7_clink_c',
                    'type'  => 'link_color',
                    'title' => esc_html__( 'Link Colors', 'restly' ),
                    'output'  => '.header-number .number-content a',
                    'subtitle' => esc_html__( 'Add Button Link Colors', 'restly' ),
                ),
            ),
        ),
    
        array(
            'type'       => 'submessage',
            'style'      => 'success',
            'content'    => esc_html__( 'Tral Button', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'seven', 'all' ),
        ),
        array(
            'id'         => 'restly_header7_tral_enalbe',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Tral Button', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Tral Options if you need', 'restly' ),
            'default'    => true,
            'dependency' => array( 'restly_header_styles', '==', 'seven', 'all' ),
        ),
        array(
            'id'     => 'restly_header7_trail_group',
            'type'   => 'fieldset',
            'title'  => esc_html__( 'Trail Buton CSS Options', 'restly' ),
            'subtitle'  => esc_html__( 'Add CSS for Trail Button', 'restly' ),
            'dependency' => array( 'restly_header_styles|restly_header7_tral_enalbe', '==|==', 'seven|true', 'all' ),
            'fields' => array(
                array(
                    'type'       => 'submessage',
                    'style'      => 'success',
                    'content'    => esc_html__( 'Normal CSS SETTINGS', 'restly' ),
                ),
                array(
                    'id'          => 'restly_h7_trial_tc',
                    'type'        => 'color',
                    'title'       => esc_html__( 'Text Color', 'restly' ),
                    'subtitle'    => esc_html__( 'Add Button Text Color', 'restly' ),
                    'dependency'  => array( 'restly_header_styles', '==', 'seven', 'all' ),
                    'output_mode' => 'color',
                    'output'      => '.button-tral a.theme-btns',
                ),
                array(
                    'id'          => 'restly_h7_trial_tbc',
                    'type'        => 'color',
                    'title'       => esc_html__( 'background Color', 'restly' ),
                    'subtitle'    => esc_html__( 'Add Button Background Color', 'restly' ),
                    'dependency'  => array( 'restly_header_styles', '==', 'seven', 'all' ),
                    'output_mode' => 'background-color',
                    'output'      => '.button-tral a.theme-btns',
                ),
                
                array(
                    'type'       => 'submessage',
                    'style'      => 'success',
                    'content'    => esc_html__( 'Button Hover CSS SETTINGS', 'restly' ),
                ),

                array(
                    'id'          => 'restly_h7_trial_thc',
                    'type'        => 'color',
                    'title'       => esc_html__( 'Hover Text Color', 'restly' ),
                    'subtitle'    => esc_html__( 'Add Button Text Color', 'restly' ),
                    'dependency'  => array( 'restly_header_styles', '==', 'seven', 'all' ),
                    'output_mode' => 'color',
                    'output'      => '.button-tral a.theme-btns:hover',
                ),
                array(
                    'id'          => 'restly_h7_trial_tbhc',
                    'type'        => 'color',
                    'title'       => esc_html__( 'Hover background Color', 'restly' ),
                    'subtitle'    => esc_html__( 'Add Button Background Color', 'restly' ),
                    'dependency'  => array( 'restly_header_styles', '==', 'seven', 'all' ),
                    'output_mode' => 'background-color',
                    'output'      => '.button-tral a.theme-btns:hover',
                ),
            ),
        ),

        /////////////////////////
        // Header Eight ////////
        ///////////////////////
        array(
            'id'         => 'restly_show_hlogo8',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Logo', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Logo Options if you need', 'restly' ),
            'default'    => true,
            'dependency' => array( 'restly_header_styles', '==', 'eight', 'all' ),
        ),
        array(
            'id'         => 'restly_logo8',
            'type'       => 'media',
            'title'      => esc_html__( 'SIte Logo', 'restly' ),
            'subtitle'   => esc_html__( 'Upload Header Logo if you do not use Wordpress Default logo option ', 'restly' ),
            'library'    => 'image',
            'dependency' => array( 'restly_header_styles|restly_show_hlogo8', '==|==', 'eight|true', 'all' ),
        ),
        array(
            'id'          => 'restly_logo8_size',
            'type'        => 'number',
            'title'       => esc_html__( 'Logo Size', 'restly' ),
            'subtitle'       => esc_html__( 'Add logo Size if you need Logo Size', 'restly' ),
            'unit'        => 'px',
            'output'      => '.header-eight .site-branding img',
            'output_mode' => 'width',
            'dependency'  => array( 'restly_header_styles', '==', 'eight', 'all' ),
        ),
        array(
            'id'         => 'restly_logo8_bg',
            'type'       => 'color',
            'title'      => esc_html__( 'Logo Background', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Logo Background', 'restly' ),
            'default'    => '#f43336',
            'dependency' => array( 'restly_header_styles', '==', 'eight', 'all' ),
            'output'     => '.header-eight .logo-area a',
            'output_mode' => 'background-color'
        ),
        array(
            'id'          => 'restly_logo8_space',
            'type'        => 'spacing',
            'title'       => esc_html__( 'Padding', 'restly' ),
            'subtitle'       => esc_html__( 'Add Logo Area Padding', 'restly' ),
            'output'      => '.header-eight .logo-area a',
            'output_mode' => 'padding', // or margin, relative
            'default'     => array(
              'unit'      => 'px',
            ),
            'dependency' => array( 'restly_header_styles', '==', 'eight', 'all' ),
        ),
        array(
            'id'          => 'restly_logo8_radius',
            'type'        => 'spacing',
            'title'       => esc_html__( 'Border Radius', 'restly' ),
            'subtitle'       => esc_html__( 'Add Logo Border Radius', 'restly' ),
            'output'      => '.header-eight .logo-area a',
            'output_mode' => 'border-radius', // or margin, relative
            'default'     => array(
              'unit'      => 'px',
            ),
            'dependency' => array( 'restly_header_styles', '==', 'eight', 'all' ),
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'success',
            'content'    => esc_html__( 'Top Header Options', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'eight', 'all' ),
        ),
        array(
            'id'         => 'restly_show_top_header8',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Top Header', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Top Header Option', 'restly' ),
            'default'    => true,
            'dependency' => array( 'restly_header_styles', '==', 'eight', 'all' ),
        ),
        array(
            'id'         => 'restly_top_header8_bg',
            'type'       => 'background',
            'title'      => esc_html__( 'Background', 'restly' ),
            'subtitle'   => esc_html__( 'Add Background Color or Image', 'restly' ),
            'dependency' => array( 'restly_header_styles|restly_show_top_header8', '==|==', 'eight|true', 'all' ),
            'output'     => '.header-eight .header-top',
        ),
        array(
            'id'         => 'restly_top_header8_label_c',
            'type'       => 'color',
            'title'      => esc_html__( 'Label Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Header top Label', 'restly' ),
            'dependency' => array( 'restly_header_styles|restly_show_top_header8', '==|==', 'eight|true', 'all' ),
            'output'     => '.header-eight .header-top ul li span',
        ),
        array(
            'id'         => 'restly_top_header8_text_c',
            'type'       => 'color',
            'title'      => esc_html__( 'Text Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Header top Content', 'restly' ),
            'output'     => '.header-eight .header-top ul li',
            'dependency' => array( 'restly_header_styles|restly_show_top_header8', '==|==', 'eight|true', 'all' ),
        ),
        array(
            'id'         => 'restly_top_header8_icon_c',
            'type'       => 'color',
            'title'      => esc_html__( 'Icon Color', 'restly' ),
            'subtitle'   => esc_html__( 'Withour Link Icon Color', 'restly' ),
            'output'     => '.header-top .top8 ul li span i',
            'dependency' => array( 'restly_header_styles|restly_show_top_header8', '==|==', 'eight|true', 'all' ),
        ),
        array(
            'id'         => 'restly_top_header8_link_c',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Link Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add Color for Header top Links Normal and Hover', 'restly' ),
            'output'     => '.header-eight .header-top ul li a',
            'dependency' => array( 'restly_header_styles|restly_show_top_header8', '==|==', 'eight|true', 'all' ),
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'success',
            'content'    => esc_html__( 'Menu Section Options', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'eight', 'all' ),
        ),
        array(
            'id'         => 'restly_top_header8_menu_ncolors',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Menu Color', 'restly' ),
            'subtitle'   => esc_html__( 'Nav Menu Normal and Hover Color', 'restly' ),
            'output'     => '.main-navigation ul li a',
            'dependency' => array( 'restly_header_styles', '==', 'eight', 'all' ),
        ),
        array(
            'id'         => 'restly_header8_menu_bg',
            'type'       => 'background',
            'title'      => esc_html__( 'Background', 'restly' ),
            'subtitle'   => esc_html__( 'Add Background Color for Menu Area', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'eight', 'all' ),
            'output'     => '.header-eight .main-header',
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'Sub menu Options', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'eight', 'all' ),
        ),
        array(
            'id'         => 'restly_header8_menu_colors',
            'type'       => 'color_group',
            'title'      => esc_html__( 'Sub menu Colors', 'restly' ),
            'subtitle'   => esc_html__( 'Add SubMenu Color', 'restly' ),
            'options'    => array(
                'restly_hea8_submeni_bgc'     => esc_html__( 'Box Background', 'restly' ),
                'restly_hea8_submeni_textc'   => esc_html__( 'Text Color', 'restly' ),
                'restly_hea8_submeni_texthc'  => esc_html__( 'Text Hover/active Color', 'restly' ),
                'restly_hea8_submeni_texthbg' => esc_html__( 'Hover/active BG Color', 'restly' ),
            ),
            'default'    => array(
                'restly_hea8_submeni_bgc'     => '#ffffff',
                'restly_hea8_submeni_textc'   => '#1d2c38',
                'restly_hea8_submeni_texthc'  => '#ffffff',
                'restly_hea8_submeni_texthbg' => '#f43336',
            ),
            'dependency' => array( 'restly_header_styles', '==', 'eight', 'all' ),
        ),
        
        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'CTA Button Option', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'eight', 'all' ),
        ),
        array(
            'id'         => 'restly_show_cta8',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable CTA Button', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Header CTA button if you need', 'restly' ),
            'default'    => true,
            'dependency' => array( 'restly_header_styles', '==', 'eight', 'all' ),
        ),
        array(
            'id'          => 'restly_cta_bg8',
            'type'        => 'color',
            'title'       => esc_html__( 'CTA Button Bg', 'restly' ),
            'subtitle'    => esc_html__( 'Add CTA Button Background Color', 'restly' ),
            'default'     => '#104cba',
            'output'      => '.header-eight .button .theme-btns',
            'output_mode' => 'background-color',
            'dependency'  => array( 'restly_header_styles|restly_show_cta8', '==|==', 'eight|true', 'all' ),
        ),
        array(
            'id'          => 'restly_cta_bgh8',
            'type'        => 'color',
            'title'       => esc_html__( 'CTA Button Hover Bg', 'restly' ),
            'subtitle'    => esc_html__( 'Add CTA Button Hover Background Color', 'restly' ),
            'default'     => '#1d2c38',
            'output'      => '.header-eight .button .theme-btns:hover',
            'output_mode' => 'background-color',
            'dependency'  => array( 'restly_header_styles|restly_show_cta8', '==|==', 'eight|true', 'all' ),
        ),
        array(
            'id'         => 'restly_cta8_text_color',
            'type'       => 'link_color',
            'title'      => esc_html__( 'CTA Button Text Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add CTA Button Text Hover and Normal Color', 'restly' ),
            'output'     => '.header-eight .button .theme-btns',
            'dependency' => array( 'restly_header_styles|restly_show_cta8', '==|==', 'eight|true', 'all' ),
            'default'    => array(
                'color' => '#ffffff',
                'hover' => '#ffffff',
            ),
        ),
        // Search 
        array(
            'id'         => 'restly_show_search8',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Search Icon', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Search Icon if you need', 'restly' ),
            'default'    => true,
            'dependency' => array( 'restly_header_styles', '==', 'eight', 'all' ),
        ),
        array(
            'id'         => 'restly_search8_icon_c',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Icon Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add normal and hover colar for header search icon', 'restly' ),
            'output'     => '.header-eight .button.search-open',
            'dependency' => array(
                array( 'restly_show_search8', '==', 'true' ),
                array( 'restly_header_styles',   '==', 'eight','all' ),
            ),
        ),

        /////////////////////////
        // Header Nine ////////
        ///////////////////////
        array(
            'id'         => 'restly_show_hlogo9',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Logo', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Logo Options if you need', 'restly' ),
            'default'    => true,
            'dependency' => array( 'restly_header_styles', '==', 'nine', 'all' ),
        ),
        array(
            'id'         => 'restly_logo9',
            'type'       => 'media',
            'title'      => esc_html__( 'SIte Logo', 'restly' ),
            'subtitle'   => esc_html__( 'Upload Header Logo if you do not use Wordpress Default logo option ', 'restly' ),
            'library'    => 'image',
            'dependency' => array( 'restly_header_styles|restly_show_hlogo9', '==|==', 'nine|true', 'all' ),
        ),
        array(
            'id'          => 'restly_header9_border_color',
            'type'        => 'color',
            'title'       => esc_html__( 'Border Color', 'restly' ),
            'subtitle'    => esc_html__( 'Add Header Border Color', 'restly' ),
            'default'     => 'rgba(0,0,0,0)',
            'dependency'  => array( 'restly_header_styles', '==', 'nine', 'all' ),
            'output_mode' => 'border-color',
            'output'      => '.header-nine .main-header',
        ),
        array(
            'id'          => 'restly_logo9_size',
            'type'        => 'number',
            'title'       => esc_html__( 'Logo Size', 'restly' ),
            'subtitle'       => esc_html__( 'Add logo Size if you need Logo Size', 'restly' ),
            'unit'        => 'px',
            'output'      => '.header-nine .site-branding img',
            'output_mode' => 'width',
            'dependency'  => array( 'restly_header_styles', '==', 'nine', 'all' ),
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'success',
            'content'    => esc_html__( 'Menu Section Options', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'nine', 'all' ),
        ),
        array(
            'id'         => 'restly_top_header9_menu_ncolors',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Menu Color', 'restly' ),
            'subtitle'   => esc_html__( 'Nav Menu Normal and Hover Color', 'restly' ),
            'output'     => '.header-nine .main-navigation ul li a',
            'dependency' => array( 'restly_header_styles', '==', 'nine', 'all' ),
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'Sub menu Options', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'nine', 'all' ),
        ),
        array(
            'id'         => 'restly_header9_menu_submenu',
            'type'       => 'color_group',
            'title'      => esc_html__( 'Sub menu Colors', 'restly' ),
            'subtitle'   => esc_html__( 'Add SubMenu Color', 'restly' ),
            'options'    => array(
                'restly_hea9_submeni_bgc'     => esc_html__( 'Box Background', 'restly' ),
                'restly_hea9_submeni_textc'   => esc_html__( 'Text Color', 'restly' ),
                'restly_hea9_submeni_texthc'  => esc_html__( 'Text Hover/active Color', 'restly' ),
                'restly_hea9_submeni_texthbg' => esc_html__( 'Hover/active BG Color', 'restly' ),
            ),
            'dependency' => array( 'restly_header_styles', '==', 'nine', 'all' ),
        ),
        
        // Search 
        array(
            'id'         => 'restly_show_search9',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Search Icon', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Search Icon if you need', 'restly' ),
            'default'    => true,
            'dependency' => array( 'restly_header_styles', '==', 'nine', 'all' ),
        ),
        array(
            'id'         => 'restly_search9_icon_c',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Icon Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add normal and hover colar for header search icon', 'restly' ),
            'output'     => '.header-nine .button.search-open',
            'dependency' => array(
                array( 'restly_show_search9', '==', 'true' ),
                array( 'restly_header_styles',   '==', 'nine','all' ),
            ),
        ),
        // Login
        array(
            'id'         => 'restly_show_login9',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Login Button', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Login/Signup Button if you need', 'restly' ),
            'default'    => true,
            'dependency' => array( 'restly_header_styles', '==', 'nine', 'all' ),
        ),
        array(
            'id'      => 'restly_show_login9_text',
            'type'    => 'text',
            'title'   => esc_html__( 'Add Button Text', 'restly' ),
            'subtitle'=> esc_html__( 'Add Button Text', 'restly' ),
            'default' => esc_html__( 'WALLET CONNECT', 'restly' ),
            'dependency' => array( 'restly_header_styles|restly_show_login9', '==|==', 'nine|true', 'all' ),
        ),
        array(
            'id'    => 'restly_clogin9_link',
            'type'  => 'link',
            'title'   => esc_html__( 'Add Button Link', 'restly' ),
            'subtitle'=> esc_html__( 'Add Button Custom Link', 'restly' ),
            'dependency' => array( 'restly_header_styles|restly_show_login9', '==|==|==', 'nine|true|true', 'all' ),
            'default'  => array(
                'url'    => '#',
                'text'   => '',
                'target' => '_blank'
            ),
        ),
        array(
            'id'        => 'restly_login9_colors',
            'type'      => 'color_group',
            'title'   => esc_html__( 'Add Colors', 'restly' ),
            'title'   => esc_html__( 'Add Colors for login button', 'restly' ),
            'dependency' => array( 'restly_header_styles|restly_show_login9', '==|==', 'nine|true', 'all' ),
            'options'   => array(
              'restly_login9_bocolor' => esc_html__( 'Border Color', 'restly' ),
              'restly_login9_bgcolor' => esc_html__( 'Background Color', 'restly' ),
              'restly_login9_tcolor' => esc_html__( 'Text Color', 'restly' ),
              'restly_login9_hbocolor' => esc_html__( 'Hover Border Color', 'restly' ),
              'restly_login9_hbgcolor' => esc_html__( 'Hover Background Color', 'restly' ),
              'restly_login9_htcolor' => esc_html__( 'Hover Text Color', 'restly' ),
            )
        ),
        // Header Cart
        array(
            'id'         => 'restly_show_minicart9',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Minicart', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Minicart if you need', 'restly' ),
            'default'    => true,
            'dependency' => array( 'restly_header_styles', '==', 'nine', 'all' ),
        ),
        array(
            'id'         => 'restly_minicart9_icon',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Icon Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add normal and hover colar for header Minicart Color', 'restly' ),
            'output'     => '.header-nine .restly-hmini a span.fas',
            'dependency' => array( 'restly_show_minicart9|restly_header_styles', '==|==', 'true|nine','all' ),
        ),

        /////////////////////////
        // HEADER TEN ////////
        ///////////////////////
        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'Header Logo', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'ten', 'all' ),
        ),
        array(
            'id'         => 'restly_show_hlogo10',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Logo', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Logo Options if you need', 'restly' ),
            'default'    => true,
            'dependency' => array( 'restly_header_styles', '==', 'ten', 'all' ),
        ),
        array(
            'id'         => 'restly_logo10',
            'type'       => 'media',
            'title'      => esc_html__( 'SIte Logo', 'restly' ),
            'subtitle'   => esc_html__( 'Upload Header Logo if you do not use Wordpress Default logo option ', 'restly' ),
            'library'    => 'image',
            'dependency' => array( 'restly_header_styles|restly_show_hlogo10', '==|==', 'ten|true', 'all' ),
        ),
        array(
            'id'          => 'restly_logo10_size',
            'type'        => 'number',
            'title'       => esc_html__( 'Logo Size', 'restly' ),
            'subtitle'       => esc_html__( 'Add logo Size if you need Logo Size', 'restly' ),
            'unit'        => 'px',
            'output'      => '.header-ten .site-branding img',
            'output_mode' => 'width',
            'dependency'  => array( 'restly_header_styles', '==', 'ten', 'all' ),
        ),
        
        array(
            'type'       => 'submessage',
            'style'      => 'success',
            'content'    => esc_html__( 'Menu Section Options', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'ten', 'all' ),
        ),
        array(
            'id'         => 'restly_top_header10_menu_ncolors',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Menu Color', 'restly' ),
            'subtitle'   => esc_html__( 'Nav Menu Normal and Hover Color', 'restly' ),
            'output'     => '.header-ten .main-navigation ul li a',
            'dependency' => array( 'restly_header_styles', '==', 'ten', 'all' ),
        ),
        array(
            'id'          => 'restly_menu_bg10',
            'type'        => 'color',
            'title'       => esc_html__( 'Background', 'restly' ),
            'subtitle'    => esc_html__( 'Add Menu Background Color', 'restly' ),
            'output'      => '.header-ten .header-upper',
            'output_mode' => 'background-color',
            'dependency'  => array( 'restly_header_styles', 'any', 'ten', 'all' ),
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'Sub menu Options', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'ten', 'all' ),
        ),
        array(
            'id'         => 'restly_header10_menu_submenu',
            'type'       => 'color_group',
            'title'      => esc_html__( 'Sub menu Colors', 'restly' ),
            'subtitle'   => esc_html__( 'Add SubMenu Color', 'restly' ),
            'options'    => array(
                'restly_hea10_submeni_bgc'     => esc_html__( 'Box Background', 'restly' ),
                'restly_hea10_submeni_textc'   => esc_html__( 'Text Color', 'restly' ),
                'restly_hea10_submeni_texthc'  => esc_html__( 'Text Hover/active Color', 'restly' ),
                'restly_hea10_submeni_texthbg' => esc_html__( 'Hover/active BG Color', 'restly' ),
            ),
            'dependency' => array( 'restly_header_styles', '==', 'ten', 'all' ),
        ),
        // Search 
        array(
            'id'         => 'restly_show_search10',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Search Icon', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Search Icon if you need', 'restly' ),
            'default'    => true,
            'dependency' => array( 'restly_header_styles', '==', 'ten', 'all' ),
        ),
        array(
            'id'         => 'restly_search10_icon_c',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Icon Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add normal and hover colar for header search icon', 'restly' ),
            'output'     => '.header-ten .button.search-open',
            'dependency' => array(
                array( 'restly_show_search10', '==', 'true' ),
                array( 'restly_header_styles',   '==', 'ten','all' ),
            ),
        ),
        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'CTA Button Option', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'ten', 'all' ),
        ),
        array(
            'id'         => 'restly_show_cta10',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable CTA Button', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Header CTA button if you need', 'restly' ),
            'default'    => true,
            'dependency' => array( 'restly_header_styles', '==', 'ten', 'all' ),
        ),
        array(
            'id'          => 'restly_cta_bg10',
            'type'        => 'color',
            'title'       => esc_html__( 'CTA Button Bg', 'restly' ),
            'subtitle'    => esc_html__( 'Add CTA Button Background Color', 'restly' ),
            'output'      => '.header-ten .button .theme-btns',
            'output_mode' => 'background-color',
            'dependency'  => array( 'restly_header_styles|restly_show_cta10', '==|==', 'ten|true', 'all' ),
        ),
        array(
            'id'          => 'restly_cta_bgh10',
            'type'        => 'color',
            'title'       => esc_html__( 'CTA Button Hover Bg', 'restly' ),
            'subtitle'    => esc_html__( 'Add CTA Button Hover Background Color', 'restly' ),
            'output'      => '.header-ten .button .theme-btns:hover',
            'output_mode' => 'background-color',
            'dependency'  => array( 'restly_header_styles|restly_show_cta10', '==|==', 'ten|true', 'all' ),
        ),
        array(
            'id'          => 'restly_cta_border10',
            'type'        => 'color',
            'title'       => esc_html__( 'CTA Button Border', 'restly' ),
            'subtitle'    => esc_html__( 'Add CTA Button Border Color', 'restly' ),
            'output'      => '.header-ten .button .theme-btns',
            'output_mode' => 'border-color',
            'dependency'  => array( 'restly_header_styles|restly_show_cta10', '==|==', 'ten|true', 'all' ),
        ),
        array(
            'id'          => 'restly_cta_borderh10',
            'type'        => 'color',
            'title'       => esc_html__( 'CTA Button Border Hover', 'restly' ),
            'subtitle'    => esc_html__( 'Add CTA Button Border Hover Color', 'restly' ),
            'output'      => '.header-ten .button .theme-btns:hover',
            'output_mode' => 'border-color',
            'dependency'  => array( 'restly_header_styles|restly_show_cta10', '==|==', 'ten|true', 'all' ),
        ),
        array(
            'id'         => 'restly_cta10_text_color',
            'type'       => 'link_color',
            'title'      => esc_html__( 'CTA Button Text Color', 'restly' ),
            'subtitle'   => esc_html__( 'Add CTA Button Text Hover and Normal Color', 'restly' ),
            'output'     => '.header-ten .button .theme-btns',
            'dependency' => array( 'restly_header_styles|restly_show_cta10', '==|==', 'ten|true', 'all' ),
        ),

        array(
            'type'       => 'submessage',
            'style'      => 'info',
            'content'    => esc_html__( 'Login Button Option', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'ten', 'all' ),
        ),
        array(
            'id'         => 'restly_login_switch10',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Login Button', 'restly' ),
            'subtitle'   => esc_html__( 'Enable Header Login Button Here', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'ten', 'all' ),
            'default'    => true,
        ),
        array(
            'id'       => 'restly_login_link10',
            'type'     => 'link',
            'title'    => esc_html__( 'Login URL', 'restly' ),
            'subtitle'    => esc_html__( 'Add link for login', 'restly' ),
            'default'  => array(
              'url'    => '#',
              'text'   => 'Codestar Framework',
              'target' => '_blank'
            ),
        ),
        array(
            'id'      => 'restly_login_text10',
            'type'    => 'text',
            'title'   => esc_html__( 'Login Text', 'restly' ),
            'subtitle'    => esc_html__( 'Add Text for login', 'restly' ),
            'default'    => esc_html__( 'Login', 'restly' ),
        ),
        array(
            'id'          => 'restly_login_color10',
            'type'        => 'color',
            'title'       => esc_html__( 'Color', 'restly' ),
            'subtitle'    => esc_html__( 'Add Login Color', 'restly' ),
            'output'      => '.header-ten a.login',
            'dependency'  => array( 'restly_header_styles|restly_login_switch10', '==|==', 'ten|true', 'all' ),
        ),
        array(
            'id'          => 'restly_login_colorh10',
            'type'        => 'color',
            'title'       => esc_html__( 'Hover Color', 'restly' ),
            'subtitle'    => esc_html__( 'Add Login Hover Color', 'restly' ),
            'output'      => '.header-ten a.login:hover',
            'dependency'  => array( 'restly_header_styles|restly_login_switch10', '==|==', 'ten|true', 'all' ),
        ),

    ),
) );
// Header Button
CSF::createSection( $restlyThemeOption, array(
    'parent' => 'restly_header_settings',
    'title'  => esc_html__( 'Header CTA Button', 'restly' ),
    'icon'   => 'fas fa-arrow-right',
    'fields' => array(
        array(
            'type'    => 'notice',
            'style'   => 'warning',
            'content'    => esc_html__( 'No This content for this header', 'restly' ),
            'dependency' => array( 'restly_header_styles', 'any', 'six,nine', 'all' ),
        ),
        array(
            'id'       => 'restly_cta_text',
            'type'     => 'text',
            'title'    => esc_html__( 'Button Text', 'restly' ),
            'subtitle' => esc_html__( 'Add Button Text for header', 'restly' ),
            'default'  => esc_html__( 'Meet With Us', 'restly' ),
            'dependency' => array( 'restly_header_styles', 'not-any', 'six,seven,nine', 'all' ),
        ),
        array(
            'id'          => 'restly_cta_select',
            'type'        => 'select',
            'title'       => esc_html__( 'Select Link Options', 'restly' ),
            'subtitle'    => esc_html__( 'Select Button option', 'restly' ),
            'placeholder' => esc_html__( 'Select an option', 'restly' ),
            'options'     => array(
                '1' => esc_html__( 'Extranal', 'restly' ),
                '2' => esc_html__( 'Page', 'restly' ),
            ),
            'default'     => '1',
            'dependency' => array(
                array( 'restly_header_styles', 'not-any', 'six,seven,nine', 'all' ),
            ),
        ),
        array(
            'id'         => 'restly_cta_link',
            'type'       => 'text',
            'title'      => esc_html__( 'CTA Link', 'restly' ),
            'subtitle'   => esc_html__( 'Add Extranla Link Here.', 'restly' ),
            'default'    => esc_html__( '#', 'restly' ),
            'dependency' => array( 'restly_header_styles|restly_header7_tral_enalbe', '==|==', 'seven|true', 'all' ),
            'dependency' => array(
                array( 'restly_header_styles', 'not-any', 'six,seven,nine', 'all' ),
                array( 'restly_cta_select', '==', '1', 'all' ),
            ),

        ),
        array(
            'id'          => 'restly_cta_page',
            'type'        => 'select',
            'title'       => esc_html__( 'Select Page', 'restly' ),
            'subtitle'    => esc_html__( 'Select Page link for button', 'restly' ),
            'placeholder' => esc_html__( 'Select a page', 'restly' ),
            'options'     => 'pages',
            'query_args'  => array(
                'posts_per_page' => -1,
            ),
            'dependency' => array(
                array( 'restly_header_styles', 'not-any', 'six,seven,nine', 'all' ),
                array( 'restly_cta_select', '==', '2', 'all' ),
            ),
        ),
        // Options for Header Seven
        array(
            'id'       => 'restly_h7_trail_text',
            'type'     => 'text',
            'title'    => esc_html__( 'Trail Button Text', 'restly' ),
            'subtitle' => esc_html__( 'Add Trail Button Text', 'restly' ),
            'default'  => esc_html__( 'Start Free Trail', 'restly' ),
            'dependency' => array( 'restly_header_styles', '==', 'seven', 'all' ),
        ),
        array(
            'id'          => 'restly_h7_trail_select',
            'type'        => 'select',
            'title'       => esc_html__( 'Select Link Options', 'restly' ),
            'subtitle'    => esc_html__( 'Select Button option', 'restly' ),
            'placeholder' => esc_html__( 'Select an option', 'restly' ),
            'options'     => array(
                '1' => esc_html__( 'Extranal', 'restly' ),
                '2' => esc_html__( 'Page', 'restly' ),
            ),
            'default'     => '1',
            'dependency' => array( 'restly_header_styles', '==', 'seven', 'all' ),
        ),
        array(
            'id'         => 'restly_h7_trail_link',
            'type'       => 'text',
            'title'      => esc_html__( 'Trail Button Link', 'restly' ),
            'subtitle'   => esc_html__( 'Add Extranla Link Here.', 'restly' ),
            'default'    => esc_html__( '#', 'restly' ),
            'dependency' => array(
                array( 'restly_header_styles', '==', 'seven', 'all' ),
                array( 'restly_h7_trail_select', '==', '1', 'all' ),
            ),

        ),
        array(
            'id'          => 'restly_h7_trail_page',
            'type'        => 'select',
            'title'       => esc_html__( 'Select Page', 'restly' ),
            'subtitle'    => esc_html__( 'Select Page link for button', 'restly' ),
            'placeholder' => esc_html__( 'Select a page', 'restly' ),
            'options'     => 'pages',
            'query_args'  => array(
                'posts_per_page' => -1,
            ),
            'dependency' => array(
                array( 'restly_header_styles', '==', 'seven', 'all' ),
                array( 'restly_h7_trail_select', '==', '2', 'all' ),
            ),
        ),
    ),
) );

// End Header Button